/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Comment;
import net.seesaa.kyoto.uml.sequence.Diagram;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class DeleteCommentCommand extends Command {

	private Comment comment;
	
	private Diagram diagram;
	
	
	/**
	 * @param comment
	 * @param diagram
	 */
	public DeleteCommentCommand(Comment comment) {
		super();
		this.comment = comment;
		this.diagram = (Diagram) comment.eContainer();
	}

	@Override
	public void execute() {
		diagram.getComments().remove(comment);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		diagram.getComments().add(comment);
	}
}
