/*
 * Created on 2005/06/06
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package net.seesaa.kyoto.uml.sequence.command;

import java.util.List;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.SequenceFactory;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * 
 * @author shida
 *
 */
public class CreateConnectionCommand extends Command {

	private Message message;
	
	private Activation source;
	
	private Activation target;

	private Point sourceLocation;
	
	private SendAnchor sendAnchor;
	
	private ReceiveAnchor receiveAnchor;
	
	private int absoluteY = 0;
	
	/**
	 * @param transition
	 */
	public CreateConnectionCommand(Message message) {
		super();
		this.message = message;
	}

	public void setSource(Activation source) {
		this.source = source;
	}

	public Activation getSource() {
		return source;
	}
	
	public void setTarget(Activation target) {
		this.target = target;
	}

	public int getAbsoluteY() {
		return absoluteY;
	}

	public void setAbsoluteY(int absoluteY) {
		this.absoluteY = absoluteY;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canExecute() {
		if (message.getType().equals(MessageType.get(MessageType.RECEIVE))) {
			List<SendAnchor> anchors = source.getOutgoing();
			for (SendAnchor anchor : anchors) {
				if (anchor.getOutgoing().getType().equals(MessageType.get(MessageType.RECEIVE))) {
					return false;
				}
			}
		}
		return true;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		super.execute();
		sendAnchor = SequenceFactory.eINSTANCE.createSendAnchor();
		sendAnchor.setOutgoing(message);
		sendAnchor.setPosition(sourceLocation.y);
		receiveAnchor = SequenceFactory.eINSTANCE.createReceiveAnchor();
		receiveAnchor.setIncoming(message);
		receiveAnchor.setPosition(absoluteY);
		sendAnchor.setOwner(source);
		receiveAnchor.setOwner(target);
		if (message.getType().equals(MessageType.get(MessageType.RECEIVE))) {
			sendAnchor.setPosition(source.getHeight() - 2);
		}
	}
	
	@Override
	public void undo() {
		source.getOutgoing().remove(sendAnchor);
		target.getIncoming().remove(receiveAnchor);
		super.undo();
	}

	public void setLocation(Point location) {
		this.sourceLocation = location;
	}

	public Point getSourceLocation() {
		return sourceLocation;
	}
	
	
}
