/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;


import net.seesaa.kyoto.uml.sequence.Comment;
import net.seesaa.kyoto.uml.sequence.Diagram;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class CreateCommentCommand extends Command {

	private Diagram diagram;
	
	private Comment comment;
	
	private Point location;
	
	private Dimension size;

	

	/**
	 * @param comment
	 * @param diagram
	 * @param location
	 * @param size
	 */
	public CreateCommentCommand(Comment comment, Diagram diagram, Point location, Dimension size) {
		super();
		this.comment = comment;
		this.diagram = diagram;
		this.location = location;
		this.size = size;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		comment.setX(location.x);
		comment.setY(location.y);
		if (size != null) {
			comment.setWidth(size.width);
			comment.setHeight(size.height);			
		} else {
			comment.setWidth(100);
			comment.setHeight(20);
		}
		diagram.getComments().add(comment);
	}
	
	@Override
	public void undo() {
		super.undo();
		diagram.getComments().remove(comment);
	}
}
