/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Actor;
import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.figure.ActorFigure;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class CreateActorCommand extends Command {

	private Diagram diagram;
	
	private Actor model;
	
	private Point location;
	
	
	/**
	 * @param diagram
	 * @param model
	 * @param location
	 */
	public CreateActorCommand(Diagram diagram, Actor model, Point location) {
		super();
		this.diagram = diagram;
		this.location = location;
		this.model = model;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		model.setX(location.x);
		model.setY(ActorFigure.VERTICAL_MARGIN);
		model.setWidth(ActorFigure.DEFAULT_SIZE.width);
		model.setHeight(ActorFigure.DEFAULT_SIZE.height);
		diagram.getContents().add(model);
	}
	
	@Override
	public void undo() {
		diagram.getContents().remove(model);
	}
}
