/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.util.EcoreModelUtil;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class ChangeStringAttributeCommand extends Command {

	private EObject model;
	
	private String old;
	
	private String name;
	
	private EStructuralFeature feature;
		
	/**
	 * @param model
	 * @param name
	 */
	public ChangeStringAttributeCommand(EObject model, String name) {
		super();
		this.model = model;
		this.name = name;
		feature = EcoreModelUtil.getStringFeature(model);
	}
	
	@Override
	public boolean canExecute() {
		return name != null || name.equals("") || feature == null || name.equals(model.eGet(feature));
	}
	@Override
	public void execute() {
		super.execute();
		old = (String) model.eGet(feature);
		model.eSet(feature, name);
	}
	
	@Override
	public void undo() {
		super.undo();
		model.eSet(feature, old);
	}
}
