/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import java.util.List;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class AutoResizeCommand extends Command {

	private Activation activation;
	
	private Activation caller;
	
	private int newHeight;
	
	private int oldHeight;
	
	
	/**
	 * @param activation
	 * @param height
	 */
	public AutoResizeCommand(Activation activation, Activation caller) {
		super();
		this.activation = activation;
		this.caller = caller;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		int myHeight = activation.getY() + activation.getHeight();
		int height = caller.getY() + caller.getHeight();
		if (myHeight < height) {
			newHeight = height - myHeight + activation.getHeight();
		}else {
			newHeight = activation.getHeight();
		}
		oldHeight = activation.getHeight();
		activation.setHeight(newHeight);
		List<SendAnchor> anchors = activation.getOutgoing();
		for (SendAnchor anchor : anchors) {
			if (anchor.getOutgoing().getType().equals(MessageType.get(MessageType.RECEIVE))) {
				chain(new MoveReturnMessageCommand(anchor));
			}
		}
		super.execute();
	}
	
	@Override
	public void undo() {
		super.undo();
		activation.setHeight(oldHeight);
	}
}
