/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.actions;

import java.util.List;

import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.ui.SequenceDiagramEditor;
import net.seesaa.kyoto.uml.sequence.util.LayoutManager;
import net.seesaa.kyoto.uml.sequence.wizard.LayoutWizard;

import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * @author shida
 *
 */
public class LayoutTestAction extends WorkbenchPartAction implements ISelectionListener {
	
	private Diagram model;
	
	private IWorkbenchWindow window;
	
	public LayoutTestAction(IWorkbenchPart part) {
		super(part);
		window = part.getSite().getWorkbenchWindow();
		part.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this);
		setActionDefinitionId("layoutTest");
		setId("layoutTest");
		setText("CAEg");
	}

	@Override
	protected boolean calculateEnabled() {
		return true;
	}

	@Override
	public void run() {
		super.run();
		LayoutWizard layoutWizard = new LayoutWizard(model);
		WizardDialog dialog = new WizardDialog(window.getShell(), layoutWizard);
		dialog.open();
		List<ObjectModel> order = layoutWizard.getModel();
		if (model != null) {
			LayoutManager layoutManager = new LayoutManager(null);
			layoutManager.layout(order, 80);			
		}
	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		model = null;
		if (part instanceof SequenceDiagramEditor) {
			SequenceDiagramEditor editor = (SequenceDiagramEditor) part;
			model = editor.getSequence();
		}
	}
	

}
