/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

/**
 * @author shida
 * 
 */
public class LayoutManager {

	private int verticalspace = 30;

	private static final int ACTIVATION_WIDTH = 20;

	private Set<Activation> callers;

	private int current;

	private int horizontalspace = 30;

	private int modelwidth = 100;

	private int modelY = 10;
	/**
	 * 
	 * @param map
	 */
	public LayoutManager(Map<String, Object> map) {

	}

	public void layout(List<ObjectModel> models, int startHeight) {
		current = startHeight;
		Diagram diagram = models.get(0).getParent();
		initLayout(diagram);
		for (ObjectModel model : models) {
			layoutVertical(model);
			current += verticalspace;
		}
		calculateReturnMessage(diagram);
		layoutHorizontal(diagram);
	}
	
	@SuppressWarnings("unchecked")
	private void layoutHorizontal(Diagram diagram) {
		List<ObjectModel> models = diagram.getContents();
		int x = horizontalspace;
		for (ObjectModel model : models) {
			model.setX(x);
			model.setHeight(current);
			model.setY(modelY);
			model.setWidth(modelwidth);
			x += (modelwidth + horizontalspace);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void layoutVertical(ObjectModel model) {
		List<Activation> activation = model.getActivations();
		for (Activation a : activation) {
			callers = new HashSet<Activation>();
			layoutSync(a);
			calculateCurrent(model.getParent());
		}
	}

	@SuppressWarnings("unchecked")
	private void initLayout(Diagram diagram) {
		List<ObjectModel> models = diagram.getContents();
		for (ObjectModel model : models) {
			List<Activation> activation = model.getActivations();
			for (Activation a : activation) {
				a.setY(current);
				a.setHeight(verticalspace);
				a.setX((modelwidth - ACTIVATION_WIDTH) / 2);
			}
		}
	}

	@SuppressWarnings("unchecked")
	private void calculateCurrent(Diagram diagram) {
		int height = 0;
		List<ObjectModel> models = diagram.getContents();
		for (ObjectModel model : models) {
			List<Activation> activation = model.getActivations();
			for (Activation a : activation) {
				int bottom = a.getY() + a.getHeight();
				if (height < bottom) {
					height = bottom;
				}
			}
		}
		current = height + verticalspace;
	}

	@SuppressWarnings("unchecked")
	private void calculateReturnMessage(Diagram diagram) {
		List<ObjectModel> models = diagram.getContents();
		for (ObjectModel model : models) {
			List<Activation> activation = model.getActivations();
			for (Activation a : activation) {
				List<SendAnchor> anchors = a.getOutgoing();
				for (SendAnchor anchor : anchors) {
					if (anchor.getOutgoing().getType().equals(MessageType.get(MessageType.RECEIVE))) {
						anchor.setPosition(a.getHeight() - 2);
					}
				}
			}
		}		
	}
	@SuppressWarnings("unchecked")
	public void layoutActivation(Activation activation, int startHeight) {
		callers = new HashSet<Activation>();
		current = startHeight;
		layoutSync(activation);
	}

	@SuppressWarnings("unchecked")
	private void layoutSync(Activation activation) {
		activation.setY(current);
		activation.setHeight(verticalspace);
		activation.setWidth(ACTIVATION_WIDTH);
		if (callers.contains(activation)) {
			callers.remove(activation);
		}
		for (Activation c : callers) {
			c.setHeight(c.getHeight() + verticalspace);
		}

		List<SendAnchor> anchors = activation.getOutgoing();
		for (SendAnchor anchor : anchors) {
			// sync message.
			if (anchor.getOutgoing().getType().equals(
					MessageType.get(MessageType.SYNC))) {
				anchor.setPosition(activation.getHeight());
				callers.add(activation);
				Activation target = anchor.getOutgoing().getTarget().getOwner();
				current = activation.getY() + activation.getHeight();
				layoutSync(target);
				current += verticalspace;
				for (Activation c : callers) {
					c.setHeight(c.getHeight() + verticalspace);
				}
				callers.remove(activation);
			}
			// async message.
			if (anchor.getOutgoing().getType().equals(
					MessageType.get(MessageType.ASYNC))) {
				anchor.setPosition(activation.getHeight());
				Activation target = anchor.getOutgoing().getTarget().getOwner();
				Set<Activation> back = new HashSet<Activation>(callers);
				callers.clear();
				current = activation.getY() + activation.getHeight();
				int current_back = current;
				layoutSync(target);
				current = current_back + verticalspace;
				callers = back;
				callers.add(activation);
				for (Activation c : callers) {
					c.setHeight(c.getHeight() + verticalspace);
				}
				callers.remove(activation);
			}
		}
	}

}
