/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.policy;

import net.seesaa.kyoto.uml.sequence.Actor;
import net.seesaa.kyoto.uml.sequence.Comment;
import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.command.CreateActorCommand;
import net.seesaa.kyoto.uml.sequence.command.CreateCommentCommand;
import net.seesaa.kyoto.uml.sequence.command.CreateObjectCommand;
import net.seesaa.kyoto.uml.sequence.command.MoveCommentCommand;
import net.seesaa.kyoto.uml.sequence.command.MoveHorizontalCommand;
import net.seesaa.kyoto.uml.sequence.command.ReorderObjectCommand;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

/**
 * @author shida
 * 
 */
public class SequenceDiagramLayoutEditPolicy extends XYLayoutEditPolicy {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy#createAddCommand(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	@Override
	protected Command createAddCommand(EditPart child, Object constraint) {
		return createChangeConstraintCommand(child, constraint);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy#createChangeConstraintCommand(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	@Override
	protected Command createChangeConstraintCommand(EditPart child,
			Object constraint) {
		if (child.getModel() instanceof ObjectModel) {
			Rectangle rectangle = (Rectangle) constraint;
			ObjectModel model = (ObjectModel) child.getModel();
			return new MoveHorizontalCommand(model, rectangle.getLocation(),
					rectangle.getSize()).chain(new ReorderObjectCommand(model
					.getParent()));
		}
		if (child.getModel() instanceof Comment) {
			Rectangle rectangle = (Rectangle) constraint;
			return new MoveCommentCommand((Comment) child.getModel(), rectangle);
		}
		// if (child.getModel() instanceof Node) {
		// Rectangle rectangle = (Rectangle) constraint;
		// return new ChangeConstraintCommand((Node) child.getModel(),
		// rectangle.getLocation(), rectangle.getSize());
		// }
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#getCreateCommand(org.eclipse.gef.requests.CreateRequest)
	 */
	@Override
	protected Command getCreateCommand(CreateRequest request) {
		Diagram diagram = (Diagram) getHost().getModel();
		Object object = request.getNewObject();
		if (object instanceof Actor) {
			CreateActorCommand command = new CreateActorCommand(diagram,
					(Actor) object, request.getLocation());
			return command;
		}
		if (object instanceof ObjectModel) {
			CreateObjectCommand command = new CreateObjectCommand(diagram,
					(ObjectModel) object, request.getLocation());
			return command;
		}
		if (object instanceof Comment) {
			CreateCommentCommand command = new CreateCommentCommand(
					(Comment) object, diagram, request.getLocation(), request
							.getSize());
			return command;
		}
		// Activation activation = (Activation) request.getNewObject();
		// CreateActivationCommand command = new CreateActivationCommand(
		// activation, diagram, request.getLocation(), request.getSize());
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#getDeleteDependantCommand(org.eclipse.gef.Request)
	 */
	@Override
	protected Command getDeleteDependantCommand(Request request) {
		// TODO Auto-generated method stub
		return null;
	}

}
