/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.policy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.SequencePackage;
import net.seesaa.kyoto.uml.sequence.command.CreateActivationCommand;
import net.seesaa.kyoto.uml.sequence.command.MoveDeltaCommand;
import net.seesaa.kyoto.uml.sequence.command.MoveMessageDeltaCommand;
import net.seesaa.kyoto.uml.sequence.command.MoveVerticalCommand;
import net.seesaa.kyoto.uml.sequence.util.SequenceUtil;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

/**
 * @author shida
 *
 */
public class ObjectModelLayoutEditPolicy extends XYLayoutEditPolicy {

	
	@Override
	public Command getCommand(Request request) {
		if (REQ_ADD.equals(request.getType()))
			return getHost().getParent().getCommand(request);
		return super.getCommand(request);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy#createAddCommand(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	@Override
	protected Command createAddCommand(EditPart child, Object constraint) {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy#createChangeConstraintCommand(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected Command createChangeConstraintCommand(EditPart child,
			Object constraint) {
		CompoundCommand command = new CompoundCommand("move activation with children");
		if (child.getModel() instanceof Activation) {
			Activation model = (Activation) child.getModel();
			Rectangle r = (Rectangle) getConstraintFor((Rectangle) constraint);
			List<ReceiveAnchor> receiverAnchors = model.getIncoming();
			for (ReceiveAnchor anchor : receiverAnchors) {
				Activation owner = anchor.getIncoming().getSource().getOwner();
				if (owner.getY() > r.y && !anchor.getIncoming().getType().equals(MessageType.get(MessageType.RECEIVE))) {
					return null;
				}
			}
			if (r.getSize().height == model.getHeight()) {
				//move cascade.
				int delta = r.y - model.getY();
				Set<Activation> moved = new HashSet<Activation>();
				List<ReceiveAnchor> in = model.getIncoming();
				for (ReceiveAnchor anchor : in) {
					if (!anchor.getIncoming().getType().equals(MessageType.get(MessageType.RECEIVE))) {
						command.add(new MoveMessageDeltaCommand(delta, anchor.getIncoming()));								
					}
				}
				createMoveChildCommand(command, model, delta, moved);
			} else {
				command.add(new MoveVerticalCommand(model, r.getLocation(), r.getSize()));				
			}
			List<SendAnchor> anchors = model.getOutgoing();
			for (SendAnchor anchor : anchors) {
				if (anchor.getOutgoing().getType().equals(MessageType.get(MessageType.RECEIVE))) {
					command = (CompoundCommand) SequenceUtil.createMoveReturnCommand(command, anchor);
				}
			}
		}
		return command;
	}
	
	@SuppressWarnings("unchecked")
	private void createMoveChildCommand(CompoundCommand command, Activation model, int delta, Set<Activation> moved) {
		command.add(new MoveDeltaCommand(delta, model));
		moved.add(model);
		List<SendAnchor> send = model.getOutgoing();
		for (SendAnchor anchor : send) {
			Activation target = anchor.getOutgoing().getTarget().getOwner();
			if (!anchor.getOutgoing().getType().equals(MessageType.get(MessageType.RECEIVE))) {
				if (!moved.contains(anchor.getOutgoing().getTarget().getOwner())) {
					createMoveChildCommand(command, target, delta, moved);
				}				
			}
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#getCreateCommand(org.eclipse.gef.requests.CreateRequest)
	 */
	@Override
	protected Command getCreateCommand(CreateRequest request) {
		Object host = getHost().getModel();
		Object model = request.getNewObject();
		if (host instanceof ObjectModel && model instanceof Activation) {
			ObjectModel o = (ObjectModel) host;
			Activation a = (Activation) model;
			Rectangle rectangle = (Rectangle) getConstraintFor(request);
			return new CreateActivationCommand(a, o, rectangle.getLocation(), rectangle.getSize());
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#getDeleteDependantCommand(org.eclipse.gef.Request)
	 */
	@Override
	protected Command getDeleteDependantCommand(Request request) {
		// TODO Auto-generated method stub
		return null;
	}

	
}
