/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.policy;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.command.DeleteConnectorCommand;
import net.seesaa.kyoto.uml.sequence.command.DeleteObjectCommand;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author shida
 *
 */
public class ObjectComponentEditPolicy extends ComponentEditPolicy {

	@Override
	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		CompoundCommand command = new CompoundCommand("remove object");
		ObjectModel model = (ObjectModel) getHost().getModel();
		for (Object o : model.getActivations()) {
			Activation a = (Activation) o;
			for (Object ao : a.getOutgoing()) {
				SendAnchor anchor = (SendAnchor) ao;
				command.add(new DeleteConnectorCommand(anchor.getOutgoing()));
			}
			for (Object ao : a.getIncoming()) {
				ReceiveAnchor anchor = (ReceiveAnchor) ao;
				command.add(new DeleteConnectorCommand(anchor.getIncoming()));
			}
		}
		command.add(new DeleteObjectCommand(model));
		return command;
	}
	
}
