/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.policy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

/**
 * @author shida
 *
 */
public class MessageCellEditorLocator implements CellEditorLocator {

	private IFigure figure;
	
	
	/**
	 * @param figure
	 */
	public MessageCellEditorLocator(IFigure figure) {
		super();
		this.figure = figure;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.gef.tools.CellEditorLocator#relocate(org.eclipse.jface.viewers.CellEditor)
	 */
	public void relocate(CellEditor celleditor) {
	    Text text = (Text) celleditor.getControl();
	    Rectangle rect = figure.getBounds().getCopy();
	    figure.translateToAbsolute(rect);
	    int width = rect.width;
	    if (rect.width < 100) {
	    	width = 100;
	    }
	    text.setBounds(rect.x, rect.y, width, 16);
	}

}
