/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.figure;

import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.SequencePlugin;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

/**
 * @author shida
 *
 */
public class ObjectModelFigure extends Figure implements ISequenceFigure {

	public static final int LABEL_HEIGHT = 25;
	
	public static final int VERTICAL_MARGIN = 10;
	
	private static final int LINE_WIDTH = 1;
	
	public static final Dimension DEFAULT_SIZE = new Dimension(100, 800);
	
	public static final Image DEFAULT_IMAGE = ImageDescriptor.createFromFile(SequencePlugin.class, "icon/object_model.gif").createImage();

	private String name = "";
	
	/**
	 * 
	 */
	public ObjectModelFigure() {
		super();
		setFocusTraversable(true);
	}
	
	protected String getName() {
		return name;
	}
	@Override
	public void paint(Graphics graphics) {
		graphics.setAntialias(SWT.ON);
		super.paint(graphics);
	}
	@Override
	protected void paintBorder(Graphics graphics) {
		Rectangle r = Rectangle.SINGLETON;
		r.setLocation(getBounds().getTopLeft());
		r.setSize(getBounds().width - LINE_WIDTH, LABEL_HEIGHT);
		graphics.drawRectangle(r);
	}
	
	@Override
	protected void paintFigure(Graphics graphics) {
		Rectangle r = Rectangle.SINGLETON;
		r.setLocation(getBounds().getTopLeft());
		r.setSize(getBounds().width - LINE_WIDTH, LABEL_HEIGHT);
		graphics.fillRectangle(r);
		graphics.drawImage(DEFAULT_IMAGE,r.x + 5, r.y + 5);
		graphics.drawText(name, r.x + 30, r.y + 7);
		graphics.pushState();
		graphics.setLineStyle(SWT.LINE_DASHDOT);
		Point start = getBounds().getBottom();
		Point end = getBounds().getTop().getTranslated(0, LABEL_HEIGHT);
		graphics.drawLine(start, end);
		graphics.popState();
	}
	
	@Override
	protected boolean useLocalCoordinates() {
		return true;
	}
	/*
	 *  (non-Javadoc)
	 * @see net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure#updateModel(org.eclipse.emf.ecore.EObject)
	 */
	public void updateModel(EObject obj) {
		ObjectModel model = (ObjectModel) obj;
		this.name = model.getName() != null ? model.getName() : "";
	}
	public int getDefaultVerticalMargin() {
		return VERTICAL_MARGIN;
	}
	public int getDefaultWidth() {
		return DEFAULT_SIZE.width;
	}
	public int getDefaultHeight() {
		return DEFAULT_SIZE.height;
	}
	
}
