/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.figure;

import net.seesaa.kyoto.uml.sequence.Comment;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.ecore.EObject;

/**
 * @author shida
 *
 */
public class CommentFigure extends Figure implements ISequenceFigure {

	private TextFlow nameFlow;
	/**
	 * 
	 */
	public CommentFigure() {
		super();
		setBorder(new CompoundBorder(new MarginBorder(0,0,2,2), new LineBorder()));
		setBackgroundColor(ColorConstants.tooltipBackground);
        ToolbarLayout layout = new ToolbarLayout();
        setLayoutManager(layout);
		FlowPage page = new FlowPage();
        BlockFlow block = new BlockFlow();
        nameFlow = new TextFlow();
        nameFlow.setLayoutManager(new ParagraphTextLayout(nameFlow,ParagraphTextLayout.WORD_WRAP_SOFT));
        block.add(nameFlow);
        page.add(block);
        add(page);
        setOpaque(true);
	}

	/* (non-Javadoc)
	 * @see net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure#updateModel(org.eclipse.emf.ecore.EObject)
	 */
	public void updateModel(EObject obj) {
		Comment comment = (Comment) obj;
		nameFlow.setText(comment.getContent() != null ? comment.getContent() : "");
	}

	@Override
	public void paint(Graphics graphics) {
		super.paint(graphics);
	}

	@Override
	protected void paintFigure(Graphics graphics) {
		graphics.pushState();
		graphics.setBackgroundColor(ColorConstants.lightGray);
		graphics.fillRectangle(getBounds().getCopy().translate(2,2));
		graphics.popState();
		graphics.fillRectangle(getClientArea());
	}
	/* (non-Javadoc)
	 * @see net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure#getDefaultVerticalMargin()
	 */
	public int getDefaultVerticalMargin() {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure#getDefaultWidth()
	 */
	public int getDefaultWidth() {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure#getDefaultHeight()
	 */
	public int getDefaultHeight() {
		// TODO Auto-generated method stub
		return 0;
	}

}
