/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.figure;

import net.seesaa.kyoto.uml.sequence.SequencePlugin;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

/**
 * @author shida
 *
 */
public class ActorFigure extends ObjectModelFigure implements ISequenceFigure {

	public static final int VERTICAL_MARGIN = 10;
	public static final Dimension DEFAULT_SIZE = new Dimension(60,800);
	public static final Image DEFAULT_IMAGE = ImageDescriptor.createFromFile(SequencePlugin.class, "icon/actor.gif").createImage();

	public static final int LABEL_HEIGHT = 40;
	private static final int LINE_WIDTH = 1;


	@Override
	protected void paintBorder(Graphics graphics) {
	}
	
	@Override
	protected void paintFigure(Graphics graphics) {
		Rectangle r = Rectangle.SINGLETON;
		r.setLocation(getBounds().getTopLeft());
		r.setSize(getBounds().width - LINE_WIDTH, LABEL_HEIGHT);
		graphics.drawImage(DEFAULT_IMAGE,r.x + (r.width - DEFAULT_IMAGE.getBounds().width)/2 , r.y);
		graphics.drawText(getName(), r.x + 7, r.y + 32);
		graphics.pushState();
		graphics.setLineStyle(SWT.LINE_DASHDOT);
		Point start = getBounds().getBottom();
		Point end = getBounds().getTop().getTranslated(0, LABEL_HEIGHT);
		graphics.drawLine(start, end);
		graphics.popState();
	}


}
