/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Actor;
import net.seesaa.kyoto.uml.sequence.Comment;
import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

/**
 * @author shida
 * 
 */
public class SequenceEditPartFactory implements EditPartFactory {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart rv = null;
		if (model instanceof Diagram) {
			rv = new SequenceDiagramEditPart();
		} else if (model instanceof Activation) {
			rv = new ActivationEditPart();
		} else if (model instanceof SendAnchor) {

		} else if (model instanceof Message) {
			rv = new MessageEditPart();
		} else if (model instanceof Actor) {
			rv = new ActorEditPart();
		} else if (model instanceof ObjectModel) {
			rv = new ObjectModelEditPart();
		} else if (model instanceof Comment) {
			rv = new CommentEditPart();
		}

		if (rv != null) {
			rv.setModel(model);
		}
		return rv;
	}

}
