/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

/**
 * @author shida
 *
 */
public class OutgoingAnchor extends AbstractConnectionAnchor {

	private SendAnchor anchor;
	
	public OutgoingAnchor(SendAnchor anchor, IFigure owner) {
		super(owner);
		this.anchor = anchor;
	}

	public void setModel(SendAnchor anchor) {
		this.anchor = anchor;
	}
	
	public SendAnchor getModel() {
		return anchor;
	}
	
	public Point getLocation(Point reference) {
		Rectangle r = getOwner().getBounds();	
		int x = r.x;
		/*
		 * ef̈ʒuo߂.
		 */
		ObjectModel source = anchor.getOwner().getOwner();
		ObjectModel target = anchor.getOutgoing().getTarget().getOwner().getOwner();
		if (source.getX() < target.getX()) {
			x += r.width;
		}

		int y = r.y + anchor.getPosition();
		Point p = new Point(x,y);
		getOwner().translateToAbsolute(p);
		return p;
	}

}
