/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import net.seesaa.kyoto.uml.sequence.Comment;
import net.seesaa.kyoto.uml.sequence.command.DeleteCommentCommand;
import net.seesaa.kyoto.uml.sequence.figure.CommentFigure;
import net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author shida
 * 
 */
public class CommentEditPart extends BaseGraphicalEditPart {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	@Override
	protected IFigure createFigure() {
		return new CommentFigure();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new ComponentEditPolicy() {
			@Override
			protected Command createDeleteCommand(GroupRequest deleteRequest) {
				Comment comment = (Comment) getHost().getModel();
				return new DeleteCommentCommand(comment);
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshVisuals();
	}

	@Override
	protected void refreshVisuals() {
		((ISequenceFigure) getFigure()).updateModel(getComment());
		Rectangle constraint = new Rectangle(getComment().getX(), getComment()
				.getY(), getComment().getWidth(), getComment().getHeight());
		getFigure().setBounds(constraint);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	private Comment getComment() {
		return (Comment) getModel();
	}
	
	@Override
	public void performRequest(Request req) {
		System.out.println(req);
		super.performRequest(req);
	}
}
