/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import java.util.ArrayList;
import java.util.List;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.command.CreateConnectionCommand;
import net.seesaa.kyoto.uml.sequence.policy.ActivationComponentEditPolicy;
import net.seesaa.kyoto.uml.sequence.policy.ConnectorEditPolicy;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.SWT;

/**
 * @author shida
 * 
 */
public class ActivationEditPart extends BaseGraphicalEditPart implements
		NodeEditPart {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	@Override
	protected IFigure createFigure() {
		RectangleFigure figure = new RectangleFigure() {
			@Override
			public void paint(Graphics graphics) {
				graphics.setAntialias(SWT.ON);
				super.paint(graphics);
			}
			
			@Override
			protected boolean useLocalCoordinates() {
				return true;
			}
		};
		figure.setOpaque(true);
		return figure;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.NODE_ROLE, new ConnectorEditPolicy());
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new ActivationComponentEditPolicy());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refresh();
	}

	public ConnectionAnchor getSourceConnectionAnchor(
			ConnectionEditPart connection) {
		Message message = (Message) connection.getModel();
		return new OutgoingAnchor(message.getSource(), getFigure());
	}

	public ConnectionAnchor getTargetConnectionAnchor(
			ConnectionEditPart connection) {
		Message message = (Message) connection.getModel();
		GraphicalEditPart editPart = (GraphicalEditPart) connection.getSource();
		/*
		 * ̍.
		 */
		if (editPart != null) {
			return new IncomingAnchor(message.getTarget(), getFigure(), editPart.getFigure());			
		} else {
			return null;			
		}
	}

	public ConnectionAnchor getSourceConnectionAnchor(Request request) {
		if (request instanceof CreateConnectionRequest) {
			DropRequest connectionRequest = (DropRequest) request;
			Point point = connectionRequest.getLocation();
			return new OutgoingFeedbackAnchor(getFigure(), point);
		} else if (request instanceof ReconnectRequest) {
			DropRequest connectionRequest = (DropRequest) request;
			Point point = connectionRequest.getLocation();
			return new ReconnectingFeedbackAnchor(getFigure(), point);			
		}
		return new ChopboxAnchor(getFigure());
	}

	public ConnectionAnchor getTargetConnectionAnchor(Request request) {
		if (request instanceof CreateConnectionRequest) {
			CreateConnectionRequest connectionRequest = (CreateConnectionRequest) request;
			CreateConnectionCommand command = (CreateConnectionCommand) connectionRequest.getStartCommand();
				return new IncomingFeedbackAnchor(getFigure(), command.getAbsoluteY());				
		}
		return new ChopboxAnchor(getFigure());
	}

	@Override
	protected List getModelSourceConnections() {
		List<Message> rv = new ArrayList<Message>();
		for (Object o : getActivation().getOutgoing()) {
			SendAnchor anchor = (SendAnchor) o;
			rv.add(anchor.getOutgoing());
		}
		return rv;
	}

	@Override
	protected List getModelTargetConnections() {
		List<Message> rv = new ArrayList<Message>();
		for (Object o : getActivation().getIncoming()) {
			ReceiveAnchor anchor = (ReceiveAnchor) o;
			rv.add(anchor.getIncoming());
		}
		return rv;
	}

	private Activation getActivation() {
		return (Activation) getModel();
	}

	@Override
	protected void refreshVisuals() {
		Rectangle constraint = new Rectangle(getActivation().getX() ,
				getActivation().getY(), getActivation().getWidth(),
				getActivation().getHeight());

		getFigure().setBounds(constraint);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}
}
