/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Message;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class ReconnectSourceCommand extends Command {

	private Message message;
	
	private Point sourceLocation;
	
	private int absoluteY = 0;
	
	private int oldY, oldAbsoluteY;
	
	/**
	 * @param message
	 */
	public ReconnectSourceCommand(Message message) {
		super();
		this.message = message;
	}
	
	public void setSourceLocation(Point sourceLocation) {
		this.sourceLocation = sourceLocation;
	}
	
	public void setAbsoluteY(int absoluteY) {
		this.absoluteY = absoluteY;
	}
	
	@Override
	public void execute() {
		super.execute();
		oldY = message.getSource().getPosition();
		oldAbsoluteY = message.getTarget().getPosition();
		message.getSource().setPosition(sourceLocation.y);
		message.getTarget().setPosition(absoluteY);
	}
	
	@Override
	public void undo() {
		super.undo();
		message.getSource().setPosition(oldY);
		message.getTarget().setPosition(oldAbsoluteY);
	}
}
