/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class MoveReturnMessageCommand extends Command {

	private SendAnchor anchor;
	
	private Activation caller;

	private int oldPosition;
	
	
	/**
	 * @param anchor
	 * @param caller
	 */
	public MoveReturnMessageCommand(SendAnchor anchor) {
		super();
		this.anchor = anchor;
		this.caller = anchor.getOwner();
	}

	@Override
	public void execute() {
		oldPosition = anchor.getPosition();
		anchor.setPosition(caller.getHeight() - 2);
		super.execute();
	}
	
	@Override
	public void undo() {
		super.undo();
		anchor.setPosition(oldPosition);
	}
}
