/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import java.util.Iterator;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.figure.ActivationFigure;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class MoveHorizontalCommand extends Command {

	private ObjectModel node;
	
	private Point location, oldLocation;
	
	private Dimension size, oldSize;

	public MoveHorizontalCommand(ObjectModel classifier, Point location, Dimension size) {
		this.node = classifier;
		this.location = location;
		this.size = size;
		
		this.oldLocation = new Point(classifier.getX(), classifier.getY());
		this.oldSize = new Dimension(classifier.getWidth(), classifier.getHeight());
	}

	@Override
	public void execute() {
		super.execute();
		node.setX(location.x);
		node.setWidth(size.width);
		node.setHeight(size.height);
		/*
		 * SActivationύX.
		 */
		int center = (size.width - ActivationFigure.DEFAULT_SIZE.width) /2 ;
		for (Iterator iter = node.getActivations().iterator(); iter.hasNext();) {
			Activation element = (Activation) iter.next();
			element.setX(center);
		}
	}

	@Override
	public void undo() {
		node.setX(oldLocation.x);
		node.setWidth(oldSize.width);
		node.setHeight(oldSize.height);
		/*
		 * SActivationύX.
		 */
		int center = (oldSize.width - ActivationFigure.DEFAULT_SIZE.width) /2 ;
		for (Iterator iter = node.getActivations().iterator(); iter.hasNext();) {
			Activation element = (Activation) iter.next();
			element.setX(center);
		}
	}
}
