/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class MoveDeltaCommand extends Command {

	private int delta;
	
	private Activation model;
	
	private int old;
	
	
	/**
	 * @param delta
	 * @param model
	 */
	public MoveDeltaCommand(int delta, Activation model) {
		super();
		this.delta = delta;
		this.model = model;
	}

	@Override
	public void execute() {
		old = model.getY();
		model.setY(old + delta);
	}
	
	@Override
	public void undo() {
		model.setY(old);
	}
}
