/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.ObjectModel;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class DeleteObjectCommand extends Command {

	private ObjectModel model;
	
	private Diagram parent;
	
	/**
	 * @param model
	 */
	public DeleteObjectCommand(ObjectModel model) {
		super();
		this.model = model;
	}

	@Override
	public void execute() {
		super.execute();
		parent = model.getParent();
		parent.getContents().remove(model);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		super.undo();
		parent.getContents().add(model);
	}
}
