/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.ObjectModel;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 * 
 */
public class DeleteActivationCommand extends Command {

	private Activation target;

	private ObjectModel parent;

	/**
	 * @param target
	 */
	public DeleteActivationCommand(Activation target) {
		super();
		this.target = target;
	}

	@Override
	public void execute() {
		super.execute();
		parent = target.getOwner();
		parent.getActivations().remove(target);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		super.undo();
		parent.getActivations().add(target);
	}

}
