/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.figure.ObjectModelFigure;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class CreateObjectCommand extends Command {

	private Diagram diagram;
	
	private ObjectModel model;
	
	private Point location;
	
	/**
	 * @param diagram
	 * @param model
	 * @param rectangle
	 */
	public CreateObjectCommand(Diagram diagram, ObjectModel model, Point location) {
		super();
		// TODO Auto-generated constructor stub
		this.diagram = diagram;
		this.model = model;
		this.location = location;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		model.setX(location.x);
		model.setY(ObjectModelFigure.VERTICAL_MARGIN);
		model.setWidth(ObjectModelFigure.DEFAULT_SIZE.width);
		model.setHeight(ObjectModelFigure.DEFAULT_SIZE.height);
		diagram.getContents().add(model);
	}
	
	@Override
	public void undo() {
		diagram.getContents().remove(model);
	}
}
