package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.figure.ActivationFigure;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * 
 * @author shida
 *
 */
public class CreateActivationCommand extends Command {

	private ObjectModel container;
	
	private Activation state;
	
	private Point location;
	
	private Dimension size;

	public CreateActivationCommand(Activation state, ObjectModel container, Point location, Dimension size) {
		super();
		this.state = state;
		this.container = container;
		this.location = location;
		this.size = size;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		super.execute();
		int x = (container.getWidth() - ActivationFigure.DEFAULT_SIZE.width) / 2;
		state.setX(x);
		state.setY(location.y);
		state.setWidth(ActivationFigure.DEFAULT_SIZE.width);
		if (size != null) {
			if (size.height < ActivationFigure.DEFAULT_SIZE.height) {
				state.setHeight(ActivationFigure.DEFAULT_SIZE.height);
			} else {
				state.setHeight(size.height);
			}		
		}
		container.getActivations().add(state);
	}

	@Override
	public void undo() {
		super.undo();
		container.getActivations().remove(state);
	}

}
