/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package net.seesaa.kyoto.uml.sequence.impl;

import java.util.Collection;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.SequencePackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Object Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link net.seesaa.kyoto.uml.sequence.impl.ObjectModelImpl#getName <em>Name</em>}</li>
 *   <li>{@link net.seesaa.kyoto.uml.sequence.impl.ObjectModelImpl#getActivations <em>Activations</em>}</li>
 *   <li>{@link net.seesaa.kyoto.uml.sequence.impl.ObjectModelImpl#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ObjectModelImpl extends NodeImpl implements ObjectModel {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getActivations() <em>Activations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActivations()
	 * @generated
	 * @ordered
	 */
	protected EList activations = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ObjectModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SequencePackage.eINSTANCE.getObjectModel();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SequencePackage.OBJECT_MODEL__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getActivations() {
		if (activations == null) {
			activations = new EObjectContainmentWithInverseEList(Activation.class, this, SequencePackage.OBJECT_MODEL__ACTIVATIONS, SequencePackage.ACTIVATION__OWNER);
		}
		return activations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Diagram getParent() {
		if (eContainerFeatureID != SequencePackage.OBJECT_MODEL__PARENT) return null;
		return (Diagram)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(Diagram newParent) {
		if (newParent != eContainer || (eContainerFeatureID != SequencePackage.OBJECT_MODEL__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, SequencePackage.DIAGRAM__CONTENTS, Diagram.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newParent, SequencePackage.OBJECT_MODEL__PARENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SequencePackage.OBJECT_MODEL__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SequencePackage.OBJECT_MODEL__ACTIVATIONS:
					return ((InternalEList)getActivations()).basicAdd(otherEnd, msgs);
				case SequencePackage.OBJECT_MODEL__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, SequencePackage.OBJECT_MODEL__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SequencePackage.OBJECT_MODEL__ACTIVATIONS:
					return ((InternalEList)getActivations()).basicRemove(otherEnd, msgs);
				case SequencePackage.OBJECT_MODEL__PARENT:
					return eBasicSetContainer(null, SequencePackage.OBJECT_MODEL__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case SequencePackage.OBJECT_MODEL__PARENT:
					return eContainer.eInverseRemove(this, SequencePackage.DIAGRAM__CONTENTS, Diagram.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.OBJECT_MODEL__X:
				return new Integer(getX());
			case SequencePackage.OBJECT_MODEL__Y:
				return new Integer(getY());
			case SequencePackage.OBJECT_MODEL__WIDTH:
				return new Integer(getWidth());
			case SequencePackage.OBJECT_MODEL__HEIGHT:
				return new Integer(getHeight());
			case SequencePackage.OBJECT_MODEL__NAME:
				return getName();
			case SequencePackage.OBJECT_MODEL__ACTIVATIONS:
				return getActivations();
			case SequencePackage.OBJECT_MODEL__PARENT:
				return getParent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.OBJECT_MODEL__X:
				setX(((Integer)newValue).intValue());
				return;
			case SequencePackage.OBJECT_MODEL__Y:
				setY(((Integer)newValue).intValue());
				return;
			case SequencePackage.OBJECT_MODEL__WIDTH:
				setWidth(((Integer)newValue).intValue());
				return;
			case SequencePackage.OBJECT_MODEL__HEIGHT:
				setHeight(((Integer)newValue).intValue());
				return;
			case SequencePackage.OBJECT_MODEL__NAME:
				setName((String)newValue);
				return;
			case SequencePackage.OBJECT_MODEL__ACTIVATIONS:
				getActivations().clear();
				getActivations().addAll((Collection)newValue);
				return;
			case SequencePackage.OBJECT_MODEL__PARENT:
				setParent((Diagram)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.OBJECT_MODEL__X:
				setX(X_EDEFAULT);
				return;
			case SequencePackage.OBJECT_MODEL__Y:
				setY(Y_EDEFAULT);
				return;
			case SequencePackage.OBJECT_MODEL__WIDTH:
				setWidth(WIDTH_EDEFAULT);
				return;
			case SequencePackage.OBJECT_MODEL__HEIGHT:
				setHeight(HEIGHT_EDEFAULT);
				return;
			case SequencePackage.OBJECT_MODEL__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SequencePackage.OBJECT_MODEL__ACTIVATIONS:
				getActivations().clear();
				return;
			case SequencePackage.OBJECT_MODEL__PARENT:
				setParent((Diagram)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.OBJECT_MODEL__X:
				return x != X_EDEFAULT;
			case SequencePackage.OBJECT_MODEL__Y:
				return y != Y_EDEFAULT;
			case SequencePackage.OBJECT_MODEL__WIDTH:
				return width != WIDTH_EDEFAULT;
			case SequencePackage.OBJECT_MODEL__HEIGHT:
				return height != HEIGHT_EDEFAULT;
			case SequencePackage.OBJECT_MODEL__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SequencePackage.OBJECT_MODEL__ACTIVATIONS:
				return activations != null && !activations.isEmpty();
			case SequencePackage.OBJECT_MODEL__PARENT:
				return getParent() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //ObjectModelImpl
