/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package net.seesaa.kyoto.uml.sequence.impl;

import java.util.Collection;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.SequencePackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Activation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link net.seesaa.kyoto.uml.sequence.impl.ActivationImpl#getOutgoing <em>Outgoing</em>}</li>
 *   <li>{@link net.seesaa.kyoto.uml.sequence.impl.ActivationImpl#getIncoming <em>Incoming</em>}</li>
 *   <li>{@link net.seesaa.kyoto.uml.sequence.impl.ActivationImpl#getOwner <em>Owner</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ActivationImpl extends NodeImpl implements Activation {
	/**
	 * The cached value of the '{@link #getOutgoing() <em>Outgoing</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutgoing()
	 * @generated
	 * @ordered
	 */
	protected EList outgoing = null;

	/**
	 * The cached value of the '{@link #getIncoming() <em>Incoming</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncoming()
	 * @generated
	 * @ordered
	 */
	protected EList incoming = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SequencePackage.eINSTANCE.getActivation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOutgoing() {
		if (outgoing == null) {
			outgoing = new EObjectContainmentWithInverseEList(SendAnchor.class, this, SequencePackage.ACTIVATION__OUTGOING, SequencePackage.SEND_ANCHOR__OWNER);
		}
		return outgoing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getIncoming() {
		if (incoming == null) {
			incoming = new EObjectContainmentWithInverseEList(ReceiveAnchor.class, this, SequencePackage.ACTIVATION__INCOMING, SequencePackage.RECEIVE_ANCHOR__OWNER);
		}
		return incoming;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ObjectModel getOwner() {
		if (eContainerFeatureID != SequencePackage.ACTIVATION__OWNER) return null;
		return (ObjectModel)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwner(ObjectModel newOwner) {
		if (newOwner != eContainer || (eContainerFeatureID != SequencePackage.ACTIVATION__OWNER && newOwner != null)) {
			if (EcoreUtil.isAncestor(this, newOwner))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newOwner != null)
				msgs = ((InternalEObject)newOwner).eInverseAdd(this, SequencePackage.OBJECT_MODEL__ACTIVATIONS, ObjectModel.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newOwner, SequencePackage.ACTIVATION__OWNER, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SequencePackage.ACTIVATION__OWNER, newOwner, newOwner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SequencePackage.ACTIVATION__OUTGOING:
					return ((InternalEList)getOutgoing()).basicAdd(otherEnd, msgs);
				case SequencePackage.ACTIVATION__INCOMING:
					return ((InternalEList)getIncoming()).basicAdd(otherEnd, msgs);
				case SequencePackage.ACTIVATION__OWNER:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, SequencePackage.ACTIVATION__OWNER, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SequencePackage.ACTIVATION__OUTGOING:
					return ((InternalEList)getOutgoing()).basicRemove(otherEnd, msgs);
				case SequencePackage.ACTIVATION__INCOMING:
					return ((InternalEList)getIncoming()).basicRemove(otherEnd, msgs);
				case SequencePackage.ACTIVATION__OWNER:
					return eBasicSetContainer(null, SequencePackage.ACTIVATION__OWNER, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case SequencePackage.ACTIVATION__OWNER:
					return eContainer.eInverseRemove(this, SequencePackage.OBJECT_MODEL__ACTIVATIONS, ObjectModel.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.ACTIVATION__X:
				return new Integer(getX());
			case SequencePackage.ACTIVATION__Y:
				return new Integer(getY());
			case SequencePackage.ACTIVATION__WIDTH:
				return new Integer(getWidth());
			case SequencePackage.ACTIVATION__HEIGHT:
				return new Integer(getHeight());
			case SequencePackage.ACTIVATION__OUTGOING:
				return getOutgoing();
			case SequencePackage.ACTIVATION__INCOMING:
				return getIncoming();
			case SequencePackage.ACTIVATION__OWNER:
				return getOwner();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.ACTIVATION__X:
				setX(((Integer)newValue).intValue());
				return;
			case SequencePackage.ACTIVATION__Y:
				setY(((Integer)newValue).intValue());
				return;
			case SequencePackage.ACTIVATION__WIDTH:
				setWidth(((Integer)newValue).intValue());
				return;
			case SequencePackage.ACTIVATION__HEIGHT:
				setHeight(((Integer)newValue).intValue());
				return;
			case SequencePackage.ACTIVATION__OUTGOING:
				getOutgoing().clear();
				getOutgoing().addAll((Collection)newValue);
				return;
			case SequencePackage.ACTIVATION__INCOMING:
				getIncoming().clear();
				getIncoming().addAll((Collection)newValue);
				return;
			case SequencePackage.ACTIVATION__OWNER:
				setOwner((ObjectModel)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.ACTIVATION__X:
				setX(X_EDEFAULT);
				return;
			case SequencePackage.ACTIVATION__Y:
				setY(Y_EDEFAULT);
				return;
			case SequencePackage.ACTIVATION__WIDTH:
				setWidth(WIDTH_EDEFAULT);
				return;
			case SequencePackage.ACTIVATION__HEIGHT:
				setHeight(HEIGHT_EDEFAULT);
				return;
			case SequencePackage.ACTIVATION__OUTGOING:
				getOutgoing().clear();
				return;
			case SequencePackage.ACTIVATION__INCOMING:
				getIncoming().clear();
				return;
			case SequencePackage.ACTIVATION__OWNER:
				setOwner((ObjectModel)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SequencePackage.ACTIVATION__X:
				return x != X_EDEFAULT;
			case SequencePackage.ACTIVATION__Y:
				return y != Y_EDEFAULT;
			case SequencePackage.ACTIVATION__WIDTH:
				return width != WIDTH_EDEFAULT;
			case SequencePackage.ACTIVATION__HEIGHT:
				return height != HEIGHT_EDEFAULT;
			case SequencePackage.ACTIVATION__OUTGOING:
				return outgoing != null && !outgoing.isEmpty();
			case SequencePackage.ACTIVATION__INCOMING:
				return incoming != null && !incoming.isEmpty();
			case SequencePackage.ACTIVATION__OWNER:
				return getOwner() != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //ActivationImpl
