package jp.sourceforge.erep.gef.screen.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.erep.gef.screen.factory.ScreenDiagramEditPartFactory;
import jp.sourceforge.erep.gef.screen.factory.ScreenDiagramPaletteFactory;
import jp.sourceforge.erep.gef.screen.factory.ScreenDiagramTreeEditPartFactory;
import jp.sourceforge.erep.model.diagram.Diagram;
import jp.sourceforge.erep.model.diagram.DiagramFactory;
import jp.sourceforge.erep.model.screen.provider.ScreenItemProviderAdapterFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite.FlyoutPreferences;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ScreenDiagramEditor extends GraphicalEditorWithFlyoutPalette {

	private ResourceSet resourceSet = new ResourceSetImpl();

	private Diagram diagram;

	private Resource resource;
	
	public ScreenDiagramEditor() {
		super();
		setEditDomain(new DefaultEditDomain(this));
	}

	@Override
	protected PaletteRoot getPaletteRoot() {
		return ScreenDiagramPaletteFactory.getPaletteRoot();
	}

	@SuppressWarnings("unchecked")
	@Override
	protected void setInput(IEditorInput input) {
		super.setInput(input);
		
		IFile file = ((IFileEditorInput) input).getFile();
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());

		resource = resourceSet.getResource(uri, true);
		if (resource.getContents().isEmpty()) {
			diagram = DiagramFactory.eINSTANCE.createDiagram();
			resource.getContents().add(diagram);
		} else {
			diagram = (Diagram) resource.getContents().get(0);
		}
		setPartName(file.getName());
	}


	@Override
	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();
		viewer.setContents(diagram);
	}

	@Override
	public void doSave(IProgressMonitor monitor) {
		Map<String, String> map = new HashMap<String, String>();
		map.put(XMLResource.OPTION_ENCODING, "UTF-8");
		try {
			resource.save(map);
		} catch (IOException e) {
			e.printStackTrace();
		}
		getCommandStack().markSaveLocation();
	}

	public void commandStackChanged(EventObject event) {
		firePropertyChange(IEditorPart.PROP_DIRTY);
		super.commandStackChanged(event);
	}
	
	public void execute(Command c) {
		getCommandStack().execute(c);
	}
	@Override
	public boolean isDirty() {
		return getCommandStack().isDirty();
	}

	@Override
	public void doSaveAs() {
	}

	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	@Override
	protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = getGraphicalViewer();
        ScalableRootEditPart root = new ScalableRootEditPart();
        viewer.setRootEditPart(root);
		viewer.setEditPartFactory(new ScreenDiagramEditPartFactory());
		viewer.setKeyHandler(
				 new GraphicalViewerKeyHandler(getGraphicalViewer()));
		ContextMenuProvider cmProvider =
			new ScreenDiagramEditorContextMenuProvider(viewer, getActionRegistry());
		viewer.setContextMenu(cmProvider);
		
		configureZoomManager(root);	
    }

	@SuppressWarnings("unchecked")
	private void configureZoomManager(ScalableRootEditPart root) {
		ZoomManager manager = root.getZoomManager();

		double[] zoomLevels = new double[] { 0.25, 0.5, 0.75, 1.0, 1.5, 2.0,
				2.5, 3.0, 4.0, 5.0, 10.0, 20.0 };
		manager.setZoomLevels(zoomLevels);
		ArrayList zoomContributions = new ArrayList();
		zoomContributions.add(ZoomManager.FIT_ALL);
		zoomContributions.add(ZoomManager.FIT_HEIGHT);
		zoomContributions.add(ZoomManager.FIT_WIDTH);
		manager.setZoomLevelContributions(zoomContributions);

		IAction action = new ZoomInAction(manager);
		getActionRegistry().registerAction(action);
		action = new ZoomOutAction(manager);
		getActionRegistry().registerAction(action);
	}
    
    public EditPart getEditPart(Point location) {
    	return getGraphicalViewer().findObjectAt(location);
    }
    
    @SuppressWarnings("unchecked")
	@Override
    protected void createActions() {
        super.createActions();
        ActionRegistry registry = getActionRegistry();

        IAction action = new DirectEditAction((IWorkbenchPart) this);
        registry.registerAction(action);

        getSelectionActions().add(action.getId());

        action = new AlignmentAction((IWorkbenchPart) this,
                PositionConstants.LEFT);
        registry.registerAction(action);
        getSelectionActions().add(action.getId());

        action = new AlignmentAction((IWorkbenchPart) this,
                PositionConstants.CENTER);
        registry.registerAction(action);
        getSelectionActions().add(action.getId());

        action = new AlignmentAction((IWorkbenchPart) this,
                PositionConstants.RIGHT);
        registry.registerAction(action);
        getSelectionActions().add(action.getId());

        action = new AlignmentAction((IWorkbenchPart) this,
                PositionConstants.TOP);
        registry.registerAction(action);
        getSelectionActions().add(action.getId());

        action = new AlignmentAction((IWorkbenchPart) this,
                PositionConstants.MIDDLE);
        registry.registerAction(action);
        getSelectionActions().add(action.getId());

        action = new AlignmentAction((IWorkbenchPart) this,
                PositionConstants.BOTTOM);
        registry.registerAction(action);
        getSelectionActions().add(action.getId());
    }

    
	@Override
	public Object getAdapter(Class type) {
		if (type == IPropertySheetPage.class) {
			PropertySheetPage page = new PropertySheetPage();
			PropertySheetEntry entry = new PropertySheetEntry() {
				@Override
				protected IPropertySource getPropertySource(Object object) {
                    if (object instanceof EditPart
                            && !(object instanceof RootEditPart)) {
                    	Object model = ((EditPart) object).getModel();
                     	return super.getPropertySource(model);
                    }
					return super.getPropertySource(object);
				}
				
			};
			entry.setPropertySourceProvider(new AdapterFactoryContentProvider(
					new ScreenItemProviderAdapterFactory()));
			page.setRootEntry(entry);
			return page;
		}
		
        if (type == ZoomManager.class)
            return ((ScalableRootEditPart) getGraphicalViewer()
                    .getRootEditPart()).getZoomManager();
        
    	if (type == IContentOutlinePage.class)
    		return new ScreenDiagramOutlinePage(new TreeViewer());
    	
		return super.getAdapter(type);
	}

	@Override
	protected FlyoutPreferences getPalettePreferences() {
		return new FlyoutPreferences() {

			public int getDockLocation() {
				return 0;
			}

			public int getPaletteState() {
				return 0;
			}

			public int getPaletteWidth() {
				return 0;
			}

			public void setDockLocation(int location) {
			}

			public void setPaletteState(int state) {
			}

			public void setPaletteWidth(int width) {
			}
			
		};
	}
	
	/**
	 * 
	 * @author shida
	 *
	 */
	public class ScreenDiagramOutlinePage extends ContentOutlinePage {	
	
		public ScreenDiagramOutlinePage(EditPartViewer viewer) {
			super(viewer);
		}
		/*
		 *  (non-Javadoc)
		 * @see org.eclipse.ui.part.IPage#createControl(org.eclipse.swt.widgets.Composite)
		 */
		public void createControl(Composite parent) {
			getViewer().createControl(parent);
			getViewer().setEditDomain(getEditDomain());
			getViewer().setEditPartFactory(new ScreenDiagramTreeEditPartFactory());
			ContextMenuProvider cmProvider = new ScreenDiagramEditorContextMenuProvider(
					getViewer(), getActionRegistry()); 
			getViewer().setContextMenu(cmProvider);
			getSite().registerContextMenu(
					"net.seesaa.kyoto.gef.screen.ui.ScreenDiagramEditor.contextmenu",
					cmProvider, getSite().getSelectionProvider());		
			getSelectionSynchronizer().addViewer(getViewer());
			getViewer().setContents(diagram);
		}
		
		/* (non-Javadoc)
		 * @see org.eclipse.ui.part.IPage#dispose()
		 */
		public void dispose() {
			getSelectionSynchronizer().removeViewer(getViewer());
			super.dispose();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.part.IPage#getControl()
		 */
		public Control getControl() {
			return getViewer().getControl();
		}
		
		/**
		 * @see org.eclipse.ui.part.IPageBookViewPage#init(org.eclipse.ui.part.IPageSite)
		 */
		public void init(IPageSite pageSite) {
			super.init(pageSite);
			ActionRegistry registry = getActionRegistry();
			IActionBars bars = pageSite.getActionBars();
			String id = ActionFactory.UNDO.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));
			id = ActionFactory.REDO.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));
			id = ActionFactory.DELETE.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));
		}
	}
}
