/**
 * 
 */
package jp.sourceforge.erep.gef.screen.tree.part;

import java.util.List;

import jp.sourceforge.erep.model.screen.Screen;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * @author shida
 *
 */
public class ScreenTreeEditPart extends BaseTreeEditPart {

	private static final Image IMAGE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD).createImage();
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshVisuals();
		refreshChildren();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected List getModelChildren() {
		return getScreen().getOutgoing();
	}

	private Screen getScreen() {
		return (Screen) getModel();
	}
	
	@Override
	protected String getText() {
		return getScreen().getId();
	}
	
	@Override
	protected Image getImage() {
		return IMAGE;
	}
}
