/**
 * 
 */
package jp.sourceforge.erep.gef.screen.tree.part;

import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.erep.gef.screen.policy.ConnectionEditPolicy;
import jp.sourceforge.erep.gef.screen.policy.NodeComponentEditPolicy;
import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractTreeEditPart;


/**
 * @author shida
 *
 */
public abstract class BaseTreeEditPart extends AbstractTreeEditPart implements Adapter {

	private Set<Notifier> notifiers = new HashSet<Notifier>();
	
	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		if (getModel() instanceof Node) {
			installEditPolicy(EditPolicy.COMPONENT_ROLE, new NodeComponentEditPolicy());
		} else if (getModel() instanceof Connector) {
			installEditPolicy(EditPolicy.COMPONENT_ROLE, new ConnectionEditPolicy());
		}
	}
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.gef.EditPart#deactivate()
	 */
	@Override
	public void deactivate() {
		super.deactivate();
		for (Notifier n : notifiers) {
			removeNotifier(n);
		}
	}
	
	/**
	 * CxgĎIuWFNgǉ.
	 * @param notifier
	 */
	@SuppressWarnings("unchecked")
	public void addNotifier(Notifier notifier) {
		if (!notifier.eAdapters().contains(this)) {
			notifier.eAdapters().add(this);			
		}
	}
	
	/**
	 * CxgĎIuWFNg.
	 * @param notifier 
	 */
	public void removeNotifier(Notifier notifier) {
		if (notifier.eAdapters().contains(this)) {
			notifier.eAdapters().remove(this);
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#getTarget()
	 */
	public Notifier getTarget() {
		return (EObject) getModel();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
	 */
	public void setTarget(Notifier newTarget) {
		notifiers.add(newTarget);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object type) {
		EClass eclass = ((EObject) getModel()).eClass();
		return eclass.isInstance(type);
	}
	
}
