/**
 * 
 */
package jp.sourceforge.erep.gef.screen.policy;

import java.util.Iterator;

import jp.sourceforge.erep.gef.screen.command.DeleteConnectorCommand;
import jp.sourceforge.erep.model.diagram.Connector;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author shida
 *
 */
public class ConnectionEditPolicy extends org.eclipse.gef.editpolicies.ConnectionEditPolicy {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.ConnectionEditPolicy#getDeleteCommand(org.eclipse.gef.requests.GroupRequest)
	 */
	@Override
	protected Command getDeleteCommand(GroupRequest request) {
		CompoundCommand command = new CompoundCommand("delete all selection");
		for (Iterator iter = request.getEditParts().iterator(); iter.hasNext();) {
			EditPart element = (EditPart) iter.next();
			if (element.getModel() instanceof Connector) {
				Connector c = (Connector) element.getModel();
				command.add(new DeleteConnectorCommand(c));
			}
		}
		return command;
	}

}
