/**
 * 
 */
package jp.sourceforge.erep.gef.screen.part;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;


/**
 * @author shida
 *
 */
public abstract class BaseGraphicalEditPart extends AbstractGraphicalEditPart implements Adapter {

	private Set<Notifier> notifiers = new HashSet<Notifier>();
	
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.gef.EditPart#deactivate()
	 */
	@Override
	public void deactivate() {
		super.deactivate();
		for (Notifier n : notifiers) {
			removeNotifier(n);
		}
	}
	
	/**
	 * CxgĎIuWFNgǉ.
	 * @param notifier
	 */
	@SuppressWarnings("unchecked")
	public void addNotifier(Notifier notifier) {
		if (!notifier.eAdapters().contains(this)) {
			notifier.eAdapters().add(this);			
		}
	}
	
	/**
	 * CxgĎIuWFNg.
	 * @param notifier 
	 */
	public void removeNotifier(Notifier notifier) {
		if (notifier.eAdapters().contains(this)) {
			notifier.eAdapters().remove(this);
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#getTarget()
	 */
	public Notifier getTarget() {
		return (EObject) getModel();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
	 */
	public void setTarget(Notifier newTarget) {
		notifiers.add(newTarget);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object type) {
		EClass eclass = ((EObject) getModel()).eClass();
		return eclass.isInstance(type);
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateVisuals();
	}
	
	protected void updateVisuals() {
		
	}
}
