/**
 * 
 */
package jp.sourceforge.erep.gef.screen.figure;

import jp.sourceforge.erep.model.screen.Screen;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FrameBorder;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * @author shida
 *
 */
public class ScreenFigure extends RectangleFigure implements IModelFigure {

	private FrameBorder border;
	
	private Label label;
	/**
	 * RXgN^.
	 */
	public ScreenFigure() {
		super();
		border = new FrameBorder() {
			protected void createBorders() {
				outer = new SchemeBorder(SCHEME_FRAME);
				inner = new TitleBarBorder() {
					public org.eclipse.swt.graphics.Color getTextColor() {
						return ColorConstants.white;
					};
				};
			};
		};
		border.setFont(JFaceResources.getDialogFont());
		
		label = new Label();
		Image image = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_TOOL_NEW_WIZARD);
		label.setIcon(image);
		label.setForegroundColor(ColorConstants.black);
		setLayoutManager(new ToolbarLayout());
		setBorder(border);
		add(label);
	}

	/**
	 * ȇ΍Wɂ.
	 */
	@Override
	protected boolean useLocalCoordinates() {
		return true;
	}

	/*
	 *  (non-Javadoc)
	 * @see net.seesaa.kyoto.gef.screen.figure.IModelFigure#update(org.eclipse.emf.ecore.EObject)
	 */
	public void update(EObject model) {
		Screen screen = (Screen) model;
		border.setLabel(screen.getId());
		label.setText(screen.getName());
	}

}
