/**
 * 
 */
package jp.sourceforge.erep.gef.screen.factory;

import jp.sourceforge.erep.gef.screen.ScreenPlugin;
import jp.sourceforge.erep.model.screen.ScreenPackage;

import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * @author shida
 * 
 */
public class ScreenDiagramPaletteFactory {

	public static PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();
		PaletteGroup group = new PaletteGroup("{"); //$NON-NLS-1$

		ToolEntry tool = new SelectionToolEntry();
		group.add(tool);
		root.setDefaultEntry(tool);

		tool = new MarqueeToolEntry();
		group.add(tool);

		root.add(group);

		PaletteDrawer drawer = new PaletteDrawer("m[h");

		EcoreModelFactory factory = null;
		CreationToolEntry entry = null;

		ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
				
		factory = new EcoreModelFactory(ScreenPackage.eINSTANCE.getScreen());
		entry = new CombinedTemplateCreationEntry("",
				"Vʂ쐬܂.",
				factory,
				factory,
				images.getImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD),
				images.getImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD));

		drawer.add(entry);

		factory = new EcoreModelFactory(ScreenPackage.eINSTANCE.getDecision());
		entry = new CombinedTemplateCreationEntry("",
				"V쐬܂.",
				factory,
				factory,
				images.getImageDescriptor(ISharedImages.IMG_OBJ_ELEMENT),
				images.getImageDescriptor(ISharedImages.IMG_OBJ_ELEMENT));
		
		drawer.add(entry);
		
		root.add(drawer);

		drawer = new PaletteDrawer("J");
		factory = new EcoreModelFactory(ScreenPackage.eINSTANCE.getTransition());
		entry = new ConnectionCreationToolEntry("ʑJ",
				"VʑJڂ쐬܂.",
				factory,
				ImageDescriptor.createFromFile(ScreenPlugin.class, "icons/connection_s16.gif"),
				ImageDescriptor.createFromFile(ScreenPlugin.class, "icons/connection_s24.gif"));
		drawer.add(entry);

		root.add(drawer);
		return root;
	}
}
