/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class CreateConnectorCommand extends Command {

	private Connector connector;
	
	private Node source;
	
	private Node target;
	
	
	/**
	 * @param connector
	 * @param source
	 * @param target
	 */
	public CreateConnectorCommand(Connector connector, Node source) {
		super();
		this.connector = connector;
		this.source = source;
	}

	/**
	 * 
	 * @param target
	 */
	public void setTarget(Node target) {
		this.target = target;
	}
	
	@Override
	public void execute() {
		super.execute();
		connector.setSource(source);
		connector.setTarget(target);
	}
	
	@Override
	public void undo() {
		super.undo();
		connector.setSource(null);
		connector.setTarget(null);
	}
}
