/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package jp.sourceforge.erep.model.screen.impl;

import java.util.Collection;

import jp.sourceforge.erep.model.diagram.Container;
import jp.sourceforge.erep.model.diagram.DiagramFactory;
import jp.sourceforge.erep.model.diagram.DiagramPackage;
import jp.sourceforge.erep.model.diagram.Dimension;
import jp.sourceforge.erep.model.diagram.Point;

import jp.sourceforge.erep.model.diagram.impl.NodeImpl;

import jp.sourceforge.erep.model.screen.Screen;
import jp.sourceforge.erep.model.screen.ScreenPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Screen</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link jp.sourceforge.erep.model.screen.impl.ScreenImpl#getId <em>Id</em>}</li>
 *   <li>{@link jp.sourceforge.erep.model.screen.impl.ScreenImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ScreenImpl extends NodeImpl implements Screen {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = "id";

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = "name";

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScreenImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ScreenPackage.eINSTANCE.getScreen();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ScreenPackage.SCREEN__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ScreenPackage.SCREEN__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ScreenPackage.SCREEN__CONTAIN:
					return ((InternalEList)getContain()).basicAdd(otherEnd, msgs);
				case ScreenPackage.SCREEN__INCOMING:
					return ((InternalEList)getIncoming()).basicAdd(otherEnd, msgs);
				case ScreenPackage.SCREEN__OUTGOING:
					return ((InternalEList)getOutgoing()).basicAdd(otherEnd, msgs);
				case ScreenPackage.SCREEN__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ScreenPackage.SCREEN__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ScreenPackage.SCREEN__CONTAIN:
					return ((InternalEList)getContain()).basicRemove(otherEnd, msgs);
				case ScreenPackage.SCREEN__LOCATION:
					return basicSetLocation(null, msgs);
				case ScreenPackage.SCREEN__SIZE:
					return basicSetSize(null, msgs);
				case ScreenPackage.SCREEN__INCOMING:
					return ((InternalEList)getIncoming()).basicRemove(otherEnd, msgs);
				case ScreenPackage.SCREEN__OUTGOING:
					return ((InternalEList)getOutgoing()).basicRemove(otherEnd, msgs);
				case ScreenPackage.SCREEN__PARENT:
					return eBasicSetContainer(null, ScreenPackage.SCREEN__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case ScreenPackage.SCREEN__PARENT:
					return eContainer.eInverseRemove(this, DiagramPackage.CONTAINER__CONTAIN, Container.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ScreenPackage.SCREEN__CONTAIN:
				return getContain();
			case ScreenPackage.SCREEN__LOCATION:
				return getLocation();
			case ScreenPackage.SCREEN__SIZE:
				return getSize();
			case ScreenPackage.SCREEN__INCOMING:
				return getIncoming();
			case ScreenPackage.SCREEN__OUTGOING:
				return getOutgoing();
			case ScreenPackage.SCREEN__PARENT:
				return getParent();
			case ScreenPackage.SCREEN__ID:
				return getId();
			case ScreenPackage.SCREEN__NAME:
				return getName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ScreenPackage.SCREEN__CONTAIN:
				getContain().clear();
				getContain().addAll((Collection)newValue);
				return;
			case ScreenPackage.SCREEN__LOCATION:
				setLocation((Point)newValue);
				return;
			case ScreenPackage.SCREEN__SIZE:
				setSize((Dimension)newValue);
				return;
			case ScreenPackage.SCREEN__INCOMING:
				getIncoming().clear();
				getIncoming().addAll((Collection)newValue);
				return;
			case ScreenPackage.SCREEN__OUTGOING:
				getOutgoing().clear();
				getOutgoing().addAll((Collection)newValue);
				return;
			case ScreenPackage.SCREEN__PARENT:
				setParent((Container)newValue);
				return;
			case ScreenPackage.SCREEN__ID:
				setId((String)newValue);
				return;
			case ScreenPackage.SCREEN__NAME:
				setName((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ScreenPackage.SCREEN__CONTAIN:
				getContain().clear();
				return;
			case ScreenPackage.SCREEN__LOCATION:
				setLocation((Point)null);
				return;
			case ScreenPackage.SCREEN__SIZE:
				setSize((Dimension)null);
				return;
			case ScreenPackage.SCREEN__INCOMING:
				getIncoming().clear();
				return;
			case ScreenPackage.SCREEN__OUTGOING:
				getOutgoing().clear();
				return;
			case ScreenPackage.SCREEN__PARENT:
				setParent((Container)null);
				return;
			case ScreenPackage.SCREEN__ID:
				setId(ID_EDEFAULT);
				return;
			case ScreenPackage.SCREEN__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ScreenPackage.SCREEN__CONTAIN:
				return contain != null && !contain.isEmpty();
			case ScreenPackage.SCREEN__LOCATION:
				return location != null;
			case ScreenPackage.SCREEN__SIZE:
				return size != null;
			case ScreenPackage.SCREEN__INCOMING:
				return incoming != null && !incoming.isEmpty();
			case ScreenPackage.SCREEN__OUTGOING:
				return outgoing != null && !outgoing.isEmpty();
			case ScreenPackage.SCREEN__PARENT:
				return getParent() != null;
			case ScreenPackage.SCREEN__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ScreenPackage.SCREEN__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

	@Override
	public Dimension getDefaultFigureSize() {
		Dimension dimension = DiagramFactory.eINSTANCE.createDimension();
		dimension.setWidth(100);
		dimension.setHeight(60);
		return dimension;
	}
} //ScreenImpl
