/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImagePattersonFunctionCalc ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImagePattersonFunctionCalc 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%lmrcImagePattersonFunctionCalc ver%I%; Date:%D% %Z%";

#include "../inc/mrcImage.h"

void
lmrcImagePattersonFunctionCalc(mrcImage* out, mrcImage* in)
{
	mrcImage fft;
	int X, Y, Z;
	double pow;

	lmrcImageFFT(&fft, in, 0);

	for(Z=-fft.HeaderN.z/2; Z< fft.HeaderN.z/2; Z++) {	
	for(Y=-fft.HeaderN.y/2; Y< fft.HeaderN.y/2; Y++) {	
	for(X=0;                X<=fft.HeaderN.x/2; X++) {	
		mrcPixelDataGet(&fft, X, Y, Z, &pow, mrcPixelPow,    mrcPixelHowNearest);
		mrcPixelDataSet(&fft, X, Y, Z, pow,  mrcPixelRePart);
		mrcPixelDataSet(&fft, X, Y, Z, 0,    mrcPixelImPart);
	}
	}
	}
	lmrcImageFFT(out, &fft, 0);	
	mrcImageFree(&fft, "in lmrcImagePattersonFunction\n");
}

void
lmrcImagePattersonFunctionPrint(FILE* fpt, mrcImage* pat, int mode)
{
	int x;
	double data;

	for(x=0; x<=pat->HeaderN.x/2; x++) {
		mrcPixelDataGet(pat, x, 0, 0, &data, mrcPixelRePart, mrcPixelHowNearest);
		fprintf(fpt, "%d %f %f\n", x, x*pat->HeaderLength.x, data);
	}
}

