package jp.ac.naka.ec.entity;

import java.text.ParseException;

import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.sensor.SensorData;
import jp.ac.naka.ec.sensor.SensorDataImpl;
import jp.ac.naka.ec.sensor.SensorData.DataType;


public class EntityInformation {
	
	private String serviceName, serviceType, uri;
	private String description ="";
	private SensorData[] sensors;
	private Location location;
	
	
	// method ?
	
	public EntityInformation(){}
	
	public EntityInformation (Entity entity) {
		setServiceType(entity.getEntityType().toString());
		setServiceName(entity.getName());
		setUri(entity.getURI().toString());
		
		setDescription( entity.getDescription());
		
		setLocation(entity.getLocation());
		setSensors(entity.getSensors());
	}


	public EntityInformation(String str) throws ParseException {
		java.util.StringTokenizer stToken = new java.util.StringTokenizer(str);
		uri = stToken.nextToken(",");
		serviceType = stToken.nextToken(",");
		if (stToken.hasMoreTokens())
			setDescription(description);
	}

	public String getDescription() {
		return description;
	}



	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}


	/**
	 * @param uri the uri to set
	 */
	public void setUri(String uri) {
		this.uri = uri.toString();
	}


	public String getUri() {
		return uri;
	}
 
	public String toString() {
		return this.uri.toString() + "," +serviceType+","+description;
	}

	/**
	 * @return the type
	 */
	public String getServiceType() {
		return serviceType;
	}

	/**
	 * @param type the type to set
	 */
	public void setServiceType(String type) {
		this.serviceType = type;
	}

	
	public String toXML() {
		StringBuilder sb = new StringBuilder();
		sb.append("<?xml version=\"1.0\"?>\r\n<eiml>\r\n");
		if (serviceName != null) {
			sb.append("\t<service name=\"");
			sb.append(serviceName);
			sb.append("\" uri=\"");
			sb.append(uri);
			sb.append("\" type=\"");
			sb.append(serviceType);
			sb.append("\">\r\n");
		} else {
			sb.append("\t<service uri=\"");
			sb.append(uri);
			sb.append("\" type=\"");
			sb.append(serviceType);
			sb.append("\">\r\n");
		}
		
		if (location != null) {
			sb.append(location.toXML("\t\t"));
		} else {
			//sb.append("<location />\r\n");
		}
		
		
		if (description != null) {
			sb.append("\t\t<description>");
			sb.append(description);
			sb.append("</description>\r\n");
		} else {
			sb.append("\t\t<description />\r\n");
		}
		
		if (sensors.length != 0) {
			for (SensorData sensor:sensors) {
				String padding = "\t\t";
				sb.append(sensor.toXML(padding));
			}
		} else {
			sb.append("\t\t<sensor />\r\n");
		}
		
		sb.append("\t</service>\r\n");
		sb.append("</eiml>");
		return sb.toString();
	}
	
	public String toYAML () {
		return null;
	}

	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}


	public SensorData[] getSensors() {
		return sensors;
	}

	public void setSensors(SensorData[] sensors) {
		this.sensors = sensors;
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}
	
	
	public static void main(String[] args) throws ParseException {
		Entity entity = new EntityImpl("sip:kasuya@localhost:5060");
		entity.setLocation(new Location("hoge","22", "30"));
		entity.setDescrpition("hogehoge");
		SensorData s = new SensorDataImpl();
		s.setName("hoge");
		s.setDataName("moxa");
		s.setDataType(DataType.Integer);
		s.setData("10");
		s.setLocation(new Location("hogehoge", "20.0", "30.0"));
		entity.addSensorData(s);
		entity.addSensorData(s);
		EntityInformation info = new EntityInformation(entity);
		System.out.println(info.toXML());
	}
}
