/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.sdp.Attribute;
import javax.sdp.Connection;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import javax.sdp.Time;
import javax.sdp.TimeDescription;
import javax.sdp.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SDPGenerator {
    protected static int limit = 3;
    private static SdpFactory factory = SdpFactory.getInstance();

    SDPGenerator() {
    }

    public static SessionDescription getRequestSessionDescription(int version, String userName, String sessionName, String host_str, List<Integer> availableAudioFormats, int audioPort, List<Integer> availableVideoFormats, int videoPort) throws UnknownHostException, SdpException {
        MediaDescription md;
        SessionDescription sdp = SDPGenerator.generateBasicSessionDescription(version, userName, sessionName, host_str);
        Vector<MediaDescription> mds = new Vector<MediaDescription>();
        if (availableAudioFormats != null) {
            md = SDPGenerator.createMediaDescription(availableAudioFormats, "audio", audioPort);
            mds.add(md);
        }
        if (availableVideoFormats != null) {
            md = SDPGenerator.createMediaDescription(availableVideoFormats, "video", videoPort);
            mds.add(md);
        }
        sdp.setMediaDescriptions(mds);
        return sdp;
    }

    private static MediaDescription createMediaDescription(List<Integer> list, String media, int port) throws IllegalArgumentException, SdpException {
        String name = "rtpmap";
        int[] formats = new int[list.size()];
        Vector<Attribute> attrs = new Vector<Attribute>();
        int i = 0;
        while (i < list.size()) {
            int num;
            if (i > limit) break;
            formats[i] = num = list.get(i).intValue();
            String value = String.valueOf(num) + " " + SDPGenerator.getAttributeValue(num);
            attrs.add(factory.createAttribute(name, value));
            ++i;
        }
        MediaDescription md = factory.createMediaDescription(media, port, 0, "RTP/AVP", formats);
        md.setAttributes(attrs);
        return md;
    }

    public static SessionDescription generateBasicSessionDescription(int version, String userName, String sessionName, String host_str) throws UnknownHostException, SdpException {
        SessionDescription sdp = null;
        InetAddress host = InetAddress.getByName(host_str);
        sdp = factory.createSessionDescription();
        Version v = factory.createVersion(version);
        String addrType = host instanceof Inet6Address ? "IP6" : "IP4";
        String networkType = "IN";
        Date date = new Date();
        long sessionVersion = date.getTime();
        Origin o = factory.createOrigin(userName, sessionVersion, sessionVersion, networkType, addrType, host.getHostAddress().toString());
        SessionName s = factory.createSessionName(sessionName);
        Time time = factory.createTime();
        TimeDescription t = factory.createTimeDescription(time);
        Vector<TimeDescription> vec = new Vector<TimeDescription>();
        vec.add(t);
        Connection c = factory.createConnection(host.getHostAddress().toString());
        sdp.setVersion(v);
        sdp.setOrigin(o);
        sdp.setTimeDescriptions(vec);
        sdp.setConnection(c);
        sdp.setSessionName(s);
        return sdp;
    }

    private static String getAttributeValue(int payload) {
        switch (payload) {
            case 0: {
                return "PCMU/8000";
            }
            case 3: {
                return "gsm/8000";
            }
            case 4: {
                return "g723/8000";
            }
            case 5: {
                return "dvi4/8000";
            }
            case 6: {
                return "dvi4/16000";
            }
            case 8: {
                return "PCMA/8000";
            }
            case 15: {
                return "g728/8000";
            }
            case 16: {
                return "dvi4/11025";
            }
            case 17: {
                return "dvi4/22050";
            }
            case 18: {
                return "g729/8000";
            }
            case 31: {
                return "H261/90000";
            }
            case 34: {
                return "H263/90000";
            }
            case 32: {
                return "MPV/90000";
            }
            case 26: {
                return "JPEG/90000";
            }
        }
        return null;
    }

    static Format findCorrespondingFormat(int sdpFormat) {
        String format = null;
        switch (sdpFormat) {
            case 0: {
                return new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
            }
            case 3: {
                return new AudioFormat("gsm/rtp", 8000.0, 8, 1);
            }
            case 4: {
                return new AudioFormat("g723/rtp", 8000.0, 8, 1);
            }
            case 5: {
                return new AudioFormat("dvi/rtp", 8000.0, 8, 1);
            }
            case 6: {
                return new AudioFormat("dvi/rtp", 16000.0, 8, 1);
            }
            case 8: {
                return new AudioFormat("alaw", 8000.0, 8, 1);
            }
            case 15: {
                return new AudioFormat("g728/rtp", 8000.0, 8, 1);
            }
            case 16: {
                return new AudioFormat("dvi/rtp", 11025.0, 8, 1);
            }
            case 17: {
                return new AudioFormat("dvi/rtp", 22050.0, 8, 1);
            }
            case 18: {
                return new AudioFormat("g729/rtp", 8000.0, 8, 1);
            }
            case 34: {
                format = "h263/rtp";
                break;
            }
            case 26: {
                format = "jpeg/rtp";
                break;
            }
            case 31: {
                format = "h261/rtp";
                break;
            }
            case 32: {
                format = "mpeg/rtp";
                break;
            }
            default: {
                return null;
            }
        }
        return new VideoFormat(format);
    }

    public static Vector<Integer> getReceivableFormats(int[] supports) {
        Vector codecs = PlugInManager.getPlugInList(null, null, (int)2);
        HashSet<Integer> vec = new HashSet<Integer>();
        for (String plugin : codecs) {
            Format[] formats;
            Format[] formatArray = formats = PlugInManager.getSupportedInputFormats((String)plugin, (int)2);
            int n = formats.length;
            int n2 = 0;
            while (n2 < n) {
                Format target;
                int i;
                AudioFormat f;
                Format format = formatArray[n2];
                if (format instanceof AudioFormat) {
                    f = (AudioFormat)format;
                    i = 0;
                    while (i < supports.length) {
                        target = SDPGenerator.findCorrespondingFormat(supports[i]);
                        if (target != null && target.isSameEncoding((Format)f)) {
                            vec.add(supports[i]);
                        }
                        ++i;
                    }
                } else if (format instanceof VideoFormat) {
                    f = (VideoFormat)format;
                    i = 0;
                    while (i < supports.length) {
                        target = SDPGenerator.findCorrespondingFormat(supports[i]);
                        if (target != null && target.isSameEncoding((Format)f)) {
                            vec.add(supports[i]);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        int[] fmts = new int[vec.size()];
        int fmt = 0;
        int i = 0;
        Iterator iter = vec.iterator();
        while (iter.hasNext()) {
            fmts[i] = fmt = ((Integer)iter.next()).intValue();
            ++i;
        }
        Arrays.sort(fmts);
        Vector<Integer> ret = new Vector<Integer>();
        i = 0;
        while (i < fmts.length) {
            ret.add(fmts[i]);
            ++i;
        }
        return ret;
    }

    private static Vector<MediaDescription> getSupportedMedia(SessionDescription sdp, int audio_port, int video_port) throws SdpException {
        Vector<Integer> audio = null;
        Vector<Integer> video = null;
        Vector mediaDescriptions = sdp.getMediaDescriptions(true);
        for (MediaDescription mediaDescription : mediaDescriptions) {
            Media media = mediaDescription.getMedia();
            Vector formats = media.getMediaFormats(true);
            int[] int_formats = new int[formats.size()];
            int i = 0;
            while (i < int_formats.length) {
                int_formats[i] = Integer.parseInt((String)formats.get(i));
                ++i;
            }
            if (media.getMediaType().equals("audio")) {
                audio = SDPGenerator.getReceivableFormats(int_formats);
                continue;
            }
            if (!media.getMediaType().equals("video")) continue;
            video = SDPGenerator.getReceivableFormats(int_formats);
        }
        Vector<MediaDescription> ret = new Vector<MediaDescription>();
        if (audio != null) {
            ret.add(SDPGenerator.createMediaDescription(audio, "audio", audio_port));
        }
        if (video != null) {
            ret.add(SDPGenerator.createMediaDescription(video, "video", video_port));
        }
        return ret;
    }

    public static SessionDescription getResponseSessionDescription(String user, int audio_port, SessionDescription sdp) throws UnknownHostException, SdpException {
        String addr = InetAddress.getLocalHost().getHostAddress();
        String session = sdp.getSessionName().getValue();
        SessionDescription ret = SDPGenerator.generateBasicSessionDescription(0, user, session, addr);
        Vector<MediaDescription> md = SDPGenerator.getSupportedMedia(sdp, audio_port, 0);
        ret.setMediaDescriptions(md);
        return ret;
    }

    public static SessionDescription getResponseSessionDescription(String user, int audio_port, int video_port, SessionDescription sdp) throws UnknownHostException, SdpException {
        String addr = InetAddress.getLocalHost().getHostAddress();
        String session = sdp.getSessionName().getValue();
        SessionDescription ret = SDPGenerator.generateBasicSessionDescription(0, user, session, addr);
        Vector<MediaDescription> md = SDPGenerator.getSupportedMedia(sdp, audio_port, video_port);
        ret.setMediaDescriptions(md);
        return ret;
    }

    public static void main(String[] args) {
        try {
            System.out.println(SDPGenerator.generateBasicSessionDescription(0, "hoge", "-", "localhost"));
            Vector<Integer> audio = new Vector<Integer>();
            audio.add(0);
            audio.add(8);
            Vector<Integer> video = new Vector<Integer>();
            video.add(31);
            SessionDescription sdp = SDPGenerator.getRequestSessionDescription(0, "hoge", "-", "localhost", audio, 10, video, 20);
            System.out.println(SDPGenerator.getResponseSessionDescription("hogehoge", 5060, 5080, sdp));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
    }
}

