/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.dht;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.entity.EntityInformationParser;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.DHTFactory;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.routing.RoutingException;

public class Chord {
    private static DHT<String> dht = null;
    public static int PORT = 3997;
    private static final int TTL = 600000;
    private static String host;
    private static Chord instance;
    private EntityInformationParser parser;
    public static String routingStyle;
    public static String routingAlgolithm;
    public static final String ENCODING = "UTF-8";
    private ByteArray secret;
    boolean init = false;
    int idSize = 0;
    private Map<ID, String> entry = new HashMap<ID, String>();

    static {
        instance = new Chord();
        routingStyle = "Iterative";
        routingAlgolithm = "Chord";
    }

    private Chord() {
        this.parser = EntityInformationParser.getInstance();
        try {
            this.secret = ByteArray.valueOf((String)"ec", (String)ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.secret = this.secret.hashWithSHA1();
    }

    public static Chord getInstance() {
        return instance;
    }

    public boolean init() throws Exception {
        if (Chord.getHost() == null) {
            Chord.setHost(Inet4Address.getLocalHost().getHostAddress());
        }
        DHTConfiguration config = DHTFactory.getDefaultConfiguration();
        config.setRoutingStyle(routingStyle);
        config.setRoutingAlgorithm(routingAlgolithm);
        config.setSelfPort(PORT);
        try {
            dht = DHTFactory.getDHT((DHTConfiguration)config);
        }
        catch (Exception e) {
            Random rand = new Random();
            config.setSelfPort(PORT + rand.nextInt(20));
            dht = DHTFactory.getDHT((DHTConfiguration)config);
        }
        System.out.println("A DHT object initialized.");
        this.init = true;
        dht.setTTLForPut(600000L);
        dht.joinOverlay(Chord.getHost(), PORT);
        Thread th = new Thread(){

            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            1.sleep(599900L);
                            Set set = Chord.this.entry.keySet();
                            Iterator iterator = set.iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block3;
                                ID id = (ID)iterator.next();
                                String value = (String)Chord.this.entry.get(id);
                                if (dht == null) continue;
                                dht.put(id, (Serializable)((Object)value));
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        th.start();
        return this.init;
    }

    public boolean init(String host, int port) throws Exception {
        PORT = port;
        Chord.setHost(host);
        this.init();
        return true;
    }

    public boolean insertEntity(Entity entity) throws Exception {
        String[] keywords;
        if (this.idSize == 0) {
            this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        }
        if ((keywords = entity.getKeywords()).length != 0) {
            String[] stringArray = keywords;
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                ID key = null;
                try {
                    key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                EntityInformation ei = new EntityInformation(entity);
                String value = ei.toXML();
                dht.put(key, (Serializable)((Object)value));
                this.entry.put(key, value);
                ++n2;
            }
        } else {
            return false;
        }
        return true;
    }

    public Entity[] getEntities(String keyword) {
        if (this.idSize == 0) {
            this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        }
        ID key = null;
        Set valueSet = null;
        try {
            key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
            valueSet = dht.get(key);
            if (valueSet == null) {
                return new Entity[0];
            }
        }
        catch (Exception e1) {
            System.err.println(e1.toString());
        }
        Entity[] entities = new Entity[valueSet.size()];
        int num = 0;
        for (ValueInfo s : valueSet) {
            String str = (String)((Object)s.getValue());
            try {
                EntityInformation info = this.parser.parse(str);
                EntityImpl entity = new EntityImpl(info);
                entities[num++] = entity;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return entities;
    }

    public boolean isInitiated() {
        return this.init;
    }

    public boolean insertEntity(String keyword, Entity entity) {
        if (dht == null) {
            return false;
        }
        if (this.idSize == 0) {
            this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        }
        ID key = null;
        try {
            key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            return false;
        }
        EntityInformation ei = new EntityInformation(entity);
        try {
            String value = ei.toXML();
            dht.put(key, (Serializable)((Object)value));
            this.entry.put(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean removeEntity(String keyword, Entity entity) {
        Set valueSet;
        this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        ID key = null;
        try {
            key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
            valueSet = dht.get(key);
        }
        catch (Exception e) {
            System.err.println("Fail to Get Entity!");
            e.printStackTrace();
            return false;
        }
        if (valueSet == null) {
            return false;
        }
        for (ValueInfo s : valueSet) {
            Set ret;
            EntityInformation info;
            String str = (String)((Object)s.getValue());
            try {
                info = this.parser.parse(str);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (!info.getUri().equals(entity.getURI().toString())) continue;
            try {
                ret = dht.remove(key, this.secret);
            }
            catch (RoutingException e) {
                System.err.println("Fail to Remove Entity!");
                e.printStackTrace();
                return false;
            }
            this.entry.remove(key);
            return ret != null;
        }
        return false;
    }

    public static void setHost(String host) {
        Chord.host = host;
    }

    public static String getHost() {
        return host;
    }
}

