/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.Host;
import gov.nist.javax.sdp.fields.SDPField;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class OriginField
extends SDPField
implements Origin {
    protected String username;
    protected long sessId;
    protected long sessVersion;
    protected String nettype;
    protected String addrtype;
    protected Host address;

    public OriginField() {
        super("o=");
    }

    public String getUsername() throws SdpParseException {
        return this.username;
    }

    public long getSessId() {
        return this.sessId;
    }

    public long getSessVersion() {
        return this.sessVersion;
    }

    public String getNettype() {
        return this.nettype;
    }

    public String getAddrtype() {
        return this.addrtype;
    }

    public Host getHost() {
        return this.address;
    }

    public void setSessId(long s) {
        this.sessId = s;
    }

    public void setSessVersion(long s) {
        this.sessVersion = s;
    }

    public void setNettype(String n) {
        this.nettype = n;
    }

    public void setAddrtype(String a) {
        this.addrtype = a;
    }

    public void setAddress(Host a) {
        this.address = a;
    }

    public void setUsername(String user) throws SdpException {
        if (user == null) {
            throw new SdpException("The user parameter is null");
        }
        this.username = user;
    }

    public long getSessionId() throws SdpParseException {
        return this.getSessId();
    }

    public void setSessionId(long id) throws SdpException {
        if (id < 0L) {
            throw new SdpException("The is parameter is <0");
        }
        this.setSessId(id);
    }

    public long getSessionVersion() throws SdpParseException {
        return this.getSessVersion();
    }

    public void setSessionVersion(long version) throws SdpException {
        if (version < 0L) {
            throw new SdpException("The version parameter is <0");
        }
        this.setSessVersion(version);
    }

    public String getAddress() throws SdpParseException {
        Host addr = this.getHost();
        if (addr == null) {
            return null;
        }
        return addr.getAddress();
    }

    public String getAddressType() throws SdpParseException {
        return this.getAddrtype();
    }

    public String getNetworkType() throws SdpParseException {
        return this.getNettype();
    }

    public void setAddress(String addr) throws SdpException {
        if (addr == null) {
            throw new SdpException("The addr parameter is null");
        }
        Host host = this.getHost();
        if (host == null) {
            host = new Host();
        }
        host.setAddress(addr);
        this.setAddress(host);
    }

    public void setAddressType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setAddrtype(type);
    }

    public void setNetworkType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setNettype(type);
    }

    public String encode() {
        return "o=" + this.username + " " + this.sessId + " " + this.sessVersion + " " + this.nettype + " " + this.addrtype + " " + this.address.encode() + "\r\n";
    }

    public Object clone() {
        OriginField retval = (OriginField)super.clone();
        if (this.address != null) {
            retval.address = (Host)this.address.clone();
        }
        return retval;
    }
}

