/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.net.Inet4Address;
import java.net.UnknownHostException;

public final class ForwarderAddress {
    private Inet4Address address;
    private int port;

    public ForwarderAddress(String hostname, int port) throws UnknownHostException {
        Inet4Address addr = null;
        try {
            addr = (Inet4Address)Inet4Address.getByName(hostname);
        }
        catch (ClassCastException e) {
            throw new UnknownHostException("Hostname is not for IPv4: " + hostname);
        }
        this.address = addr;
        this.port = port;
    }

    public ForwarderAddress(Inet4Address address, int port) {
        this.address = address;
        this.port = port;
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ForwarderAddress)) {
            return false;
        }
        ForwarderAddress other = (ForwarderAddress)obj;
        if (!this.address.equals(other.address)) {
            return false;
        }
        return this.port == other.port;
    }

    public int hashCode() {
        return this.address.hashCode() ^ this.port;
    }
}

