/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.visualizer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.util.MessagingUtility;
import ow.msgstat.CallbackOnNodeRelationship;
import ow.msgstat.StatCollector;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.StatCollectorFactory;
import ow.msgstat.impl.StatCollectorMessageFactory;
import ow.tool.util.vizframework.Visualizer;

public final class OverlayVisualizer {
    private static final Logger logger = Logger.getLogger("statcollector");
    private Visualizer viz;
    private StatCollector collector;

    public OverlayVisualizer(String transport, int idSizeInBit, String selfAddressAndPort, String contactHostAndPort, int contactPort) throws Exception {
        this.viz = new Visualizer(idSizeInBit);
        StatCollectorConfiguration config = StatCollectorFactory.getDefaultConfiguration();
        if (transport != null) {
            config.setMessagingType(transport);
        }
        if (selfAddressAndPort != null) {
            MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(selfAddressAndPort, config.getSelfPort());
            config.setSelfAddress(hostAndPort.getHostName());
            config.setSelfPort(hostAndPort.getPort());
        }
        this.collector = StatCollectorFactory.getStatCollector(config);
        this.collector.start(new VizCallback());
        if (contactHostAndPort != null) {
            MessagingAddress contact;
            MessagingProvider provider = this.collector.getMessagingProvider();
            MessageReceiver receiver = this.collector.getMessageReceiver();
            try {
                contact = provider.getMessagingAddress(contactHostAndPort, contactPort);
            }
            catch (IllegalArgumentException e) {
                contact = provider.getMessagingAddress(contactHostAndPort, config.getContactPort());
            }
            NodeCollector r = new NodeCollector(this.viz, contact, receiver, config, logger);
            Thread t = new Thread(r);
            t.setName("Node Collector in Visualizer");
            t.setDaemon(true);
            t.start();
        }
    }

    private static class NodeCollector
    implements Runnable {
        private Visualizer viz;
        private MessagingAddress initialContact;
        private IDAddressPair self;
        private MessageSender sender;
        private StatCollectorConfiguration config;
        private Logger logger;

        public NodeCollector(Visualizer viz, MessagingAddress contact, MessageReceiver receiver, StatCollectorConfiguration config, Logger logger) {
            this.viz = viz;
            this.initialContact = contact;
            this.config = config;
            this.logger = logger;
            this.self = new IDAddressPair(null, receiver.getSelfAddress());
            this.sender = receiver.getSender();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set<IDAddressPair> nodes = Collections.synchronizedSet(new HashSet());
            Set<IDAddressPair> livingNodes = Collections.synchronizedSet(new HashSet());
            IDAddressPair[] neighbors = this.requestNeighbors(this.initialContact, this.config.getNumOfNodesNodeCollectorRequests());
            if (neighbors == null) {
                this.logger.log(Level.SEVERE, "Could not contact: " + this.initialContact);
                return;
            }
            for (IDAddressPair n : neighbors) {
                nodes.add(n);
            }
            block6: while (true) {
                IDAddressPair contact = null;
                for (IDAddressPair p : nodes) {
                    if (p == null) continue;
                    contact = p;
                    break;
                }
                if (contact != null) {
                    nodes.remove(contact);
                    neighbors = this.requestNeighbors(contact.getAddress(), this.config.getNumOfNodesNodeCollectorRequests());
                    if (neighbors == null) continue;
                    livingNodes.add(contact);
                    this.viz.addNode(contact.getID(), contact.getAddress());
                    IDAddressPair[] arr$ = neighbors;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block6;
                        IDAddressPair n = arr$[i$];
                        if (n != null && !livingNodes.contains(n)) {
                            nodes.add(n);
                        }
                        ++i$;
                    }
                }
                Random rnd = new Random(System.currentTimeMillis());
                while (true) {
                    IDAddressPair[] livNodeArray;
                    int size;
                    try {
                        Thread.sleep(this.config.getCollectionInterval());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Set<IDAddressPair> i$ = livingNodes;
                    synchronized (i$) {
                        size = livingNodes.size();
                        livNodeArray = new IDAddressPair[size];
                        livingNodes.toArray(livNodeArray);
                    }
                    int index = rnd.nextInt(size);
                    IDAddressPair contact2 = livNodeArray[index];
                    neighbors = this.requestNeighbors(contact2.getAddress(), this.config.getNumOfNodesNodeCollectorRequests());
                    if (neighbors == null) {
                        livingNodes.remove(contact2);
                        this.viz.removeNode(contact2.getID());
                        continue;
                    }
                    for (IDAddressPair n : neighbors) {
                        if (n == null || livingNodes.contains(n)) continue;
                        nodes.add(n);
                    }
                    if (!nodes.isEmpty()) break;
                }
            }
        }

        private IDAddressPair[] requestNeighbors(MessagingAddress contact, int num) {
            IDAddressPair[] neighbors = null;
            Message req = StatCollectorMessageFactory.getReqNeighbors(this.self, num);
            try {
                Message rep = this.sender.sendAndReceive(contact, req);
                Serializable[] contents = rep.getContents();
                neighbors = (IDAddressPair[])contents[0];
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Failed to contact: " + contact, e);
            }
            return neighbors;
        }
    }

    private class VizCallback
    implements CallbackOnNodeRelationship {
        private VizCallback() {
        }

        public void messageSent(MessagingAddress source, MessagingAddress dest, int tag) {
            ID sourceID = OverlayVisualizer.this.collector.getID(source);
            ID destID = OverlayVisualizer.this.collector.getID(dest);
            if (sourceID != null) {
                OverlayVisualizer.this.viz.addNode(sourceID, source);
                int sourceIDSizeInBit = sourceID.getSize() * 8;
                OverlayVisualizer.this.viz.setIDSizeInBit(sourceIDSizeInBit);
            }
            if (sourceID != null && destID != null) {
                OverlayVisualizer.this.viz.addMessage(sourceID, destID, tag);
            }
        }

        public void deleteNode(MessagingAddress node) {
            ID id = OverlayVisualizer.this.collector.getID(node);
            if (id != null) {
                OverlayVisualizer.this.viz.removeNode(id);
            }
        }

        public void emphasizeNode(ID nodeID) {
            OverlayVisualizer.this.viz.emphasizeNode(nodeID);
        }

        public void markID(ID id, int hint) {
            OverlayVisualizer.this.viz.addMark(id, hint);
        }

        public void connectNodes(ID from, ID to, int colorHint) {
            OverlayVisualizer.this.viz.connectNodes(from, to, colorHint);
        }

        public void disconnectNodes(ID from, ID to, int colorHint) {
            OverlayVisualizer.this.viz.disconnectNodes(from, to, colorHint);
        }
    }
}

