/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.scenariogen.commands.ChurnCommand;
import ow.tool.scenariogen.commands.GetCommand;
import ow.tool.scenariogen.commands.HaltCommand;
import ow.tool.scenariogen.commands.HelpCommand;
import ow.tool.scenariogen.commands.JoinCommand;
import ow.tool.scenariogen.commands.PutCommand;
import ow.tool.scenariogen.commands.QuitCommand;
import ow.tool.util.shellframework.Shell;

public class Main {
    private static final String COMMAND = "owscenariogen";
    public static final String ENCODING = "UTF-8";
    public static final int DEFAULT_TTL = 604800;
    private static final Class[] COMMANDS = new Class[]{HelpCommand.class, JoinCommand.class, PutCommand.class, GetCommand.class, HaltCommand.class, ChurnCommand.class, QuitCommand.class};
    private BufferedWriter out;

    public static void main(String[] args) {
        Main gen = new Main();
        try {
            gen.start(args);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.print("Usage: owscenariogen");
        System.out.println(" <# of nodes> <output file>");
    }

    public void start(String[] args) throws IOException {
        if (args.length < 2) {
            Main.usage();
            System.exit(1);
        }
        int numNodes = Integer.parseInt(args[0]);
        ScenarioGeneratorContext context = new ScenarioGeneratorContext(numNodes);
        String fileName = args[1];
        context.setWriter(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), ENCODING))));
        BufferedReader bin = new BufferedReader(new InputStreamReader(System.in, ENCODING));
        Shell<ScenarioGeneratorContext> shell = new Shell<ScenarioGeneratorContext>(bin, System.out, COMMANDS, context, true);
        shell.run();
        bin.close();
    }

    public BufferedWriter getWriter() {
        return this.out;
    }
}

