/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.SchedulableCommand;
import ow.tool.emulator.action.ControlTask;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlCommand
implements SchedulableCommand<EmulatorContext> {
    private static final String[] NAMES = new String[]{"control"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "control <ID of app instance> <command into stdin> [...]";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) throws Exception {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        TimerTask task = this.getTimerTask(context);
        if (task == null) {
            out.println("Usage: " + this.getHelp());
            return !context.isInteractive();
        }
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER) {
            out.print("control " + args[0] + ":");
            for (int i = 1; i < args.length; ++i) {
                out.print(" " + args[i]);
            }
            out.println();
            out.flush();
        }
        task.run();
        return false;
    }

    @Override
    public TimerTask getTimerTask(ShellContext<EmulatorContext> context) throws Exception {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            return null;
        }
        int id = args[0].toLowerCase().equals("all") ? -1 : Integer.parseInt(args[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(args[1]);
        for (int i = 2; i < args.length; ++i) {
            sb.append(" ");
            sb.append(args[i]);
        }
        String command = sb.toString();
        return new ControlTask(cxt, id, out, command);
    }
}

