/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.action;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.Task;

public class HaltTask
extends TimerTask
implements Task {
    private EmulatorContext cxt;
    private PrintStream out;

    public HaltTask(EmulatorContext cxt, PrintStream out) {
        this.cxt = cxt;
        this.out = out;
    }

    public Task clone() {
        return new HaltTask(this.cxt, this.out);
    }

    public boolean doesExit() {
        return true;
    }

    public void run() {
        if (this.cxt.getEmulatorMode() != EmulatorMode.WORKER) {
            this.out.print("halt\r\n");
        }
        try {
            Collection<BufferedWriter> controlPipes = this.cxt.getAllControlPipes();
            for (BufferedWriter controlPipe : controlPipes) {
                controlPipe.write("halt\n");
                controlPipe.flush();
            }
        }
        catch (IOException e) {
            this.out.print("An IOException thrown while writing a command into a pipe:\r\n");
            e.printStackTrace(this.out);
        }
    }
}

