/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.tool.dhtshell.Utility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"remove", "delete"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "remove|delete <key> [<value>] <secret>";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ID key = Utility.parseID(args[0], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        out.print("key:   " + key + "\r\n");
        String value = null;
        ByteArray secret = null;
        if (args.length >= 3) {
            value = args[1];
            try {
                secret = ByteArray.valueOf(args[2], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            secret = secret.hashWithSHA1();
            ValueInfo<String> v = dht.remove(key, value, secret);
            out.print("value: ");
            if (v != null) {
                out.print(v.getValue() + " " + v.getTTL() / 1000L);
                secret = v.getSecret();
                if (secret != null) {
                    out.print(" " + secret);
                }
            }
            out.print("\r\n");
        } else {
            try {
                secret = ByteArray.valueOf(args[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            secret = secret.hashWithSHA1();
            Set<ValueInfo<String>> values = dht.remove(key, secret);
            if (values != null) {
                for (ValueInfo<String> v : values) {
                    out.print("value: " + v.getValue() + " " + v.getTTL() / 1000L);
                    secret = v.getSecret();
                    if (secret != null) {
                        out.print(" " + secret);
                    }
                    out.print("\r\n");
                }
            } else {
                out.print("value:\r\n");
            }
        }
        out.flush();
        return false;
    }
}

