/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaldataCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"localdata"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "localdata";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        ByteArray secret;
        Set<ValueInfo<String>> values;
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        Set<ID> keySet = dht.getLocalKeys();
        if (keySet != null && !keySet.isEmpty()) {
            out.print("Local Directory (Entries which this node has put):\r\n");
            for (ID key : keySet) {
                values = dht.getLocalValues(key);
                out.print("  key:   " + key + "\r\n");
                if (values != null) {
                    for (ValueInfo<String> v : values) {
                        out.print("  value: " + v.getValue());
                        secret = v.getSecret();
                        if (secret != null) {
                            out.print(" " + secret);
                        }
                        out.print("\r\n");
                    }
                    continue;
                }
                out.print("  value: (NULL)\r\n");
            }
        }
        if (!(keySet = dht.getGlobalKeys()).isEmpty()) {
            out.print("Global Directory (Local part of DHT):\r\n");
            for (ID key : keySet) {
                values = dht.getGlobalValues(key);
                out.print("  key:   " + key + "\r\n");
                if (values != null) {
                    for (ValueInfo<String> v : values) {
                        out.print("  value: " + v.getValue() + " " + v.getTTL() / 1000L);
                        secret = v.getSecret();
                        if (secret != null) {
                            out.print(" " + secret);
                        }
                        out.print("\r\n");
                    }
                    continue;
                }
                out.print(" value: (NULL)\r\n");
            }
        }
        out.flush();
        return false;
    }
}

